/* twpsk  - A gui application for PSK
 * Copyright (C) 1999-2005 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 2.1 - Aug 2002
 */

#include "callbox.h"

void *shareCall;   /* memory ptr - call of current station */

/*
 * Constructor
 * Set up shared memory, and create the dialog widget
 */
   Callbox::Callbox (Widget shell)
   {
      /*
       * Allocate the shared memory
       */
      if ((shmid = shmget (KEY, SHMSIZE, IPC_CREAT | 0600)) < 0)
      {
         perror ("Callbox - shmget");
         exit (1);
      }
      if ((shareCall = (char *)(shmat (shmid, NULL, 0))) == (char *) -1)
      {
         perror ("Callbox - shmat");
         exit (1);
      }

      /*
       * Build the dialog box
       * XmStrings for pushbutton and label.  Help button gets
       * renamed to "Clear".  XmNtraversal prevents the Clear
       * button from hogging the focus.
       */
      XmString xsLabel = XmStringCreateLocalized ("His Call");
      XmString xsButton = XmStringCreateLocalized ("Clear");

      /* create the dialog shell */
      //callShell = XtVaCreateWidget ("callShell", xmDialogShellWidgetClass,
      callShell = XtVaCreateWidget ("callShell", topLevelShellWidgetClass,
         shell,
         NULL);

      /* create the Prompt dialog */
      callBox = XtVaCreateWidget ("callBox", xmSelectionBoxWidgetClass,
         callShell,
         XmNwidth, 100,
         XmNdialogType, XmDIALOG_PROMPT,
         XmNtraversalOn, False,
         XmNselectionLabelString, xsLabel,
         XmNhelpLabelString, xsButton,
         NULL);

      XmStringFree (xsLabel);
      XmStringFree (xsButton);

      /* Get rid of some unwanted buttons - OK and Cancel */
      XtUnmanageChild(XmSelectionBoxGetChild (callBox, XmDIALOG_OK_BUTTON));
      XtUnmanageChild(XmSelectionBoxGetChild (callBox, XmDIALOG_CANCEL_BUTTON));

      /* Get the widget for the Clear PB - really the Help button */
      clearPB = XmSelectionBoxGetChild (callBox, XmDIALOG_HELP_BUTTON);

      /* Get the widget for the Text field and set some properties */
      /* Add the callbacks and manage the dialog box */
      callTF = XmSelectionBoxGetChild (callBox, XmDIALOG_TEXT);

      XtAddCallback (clearPB, XmNactivateCallback,
         &Callbox::clearCB, (XtPointer) this);

      XtAddCallback (callTF, XmNvalueChangedCallback, 
         &Callbox::callCB, (XtPointer) this);

      XtAddCallback (callTF, XmNmodifyVerifyCallback,
         &Callbox::callCB, (XtPointer) this);
   
      /* Set some properties on the dialog shell */
      XtVaSetValues (callShell,
         XmNmwmDecorations, MWM_DECOR_BORDER | MWM_DECOR_TITLE,
         XmNtitle, "Twpsk",
         NULL);

      XtManageChild (callBox);
      XtManageChild (callShell);

   }


   /*
    * clearCB - clears the callbox text field
    */
   void Callbox::clearCB (Widget w, XtPointer cdata, XtPointer cbs)
   {
      Callbox *ptr = (Callbox *) cdata;

      XmTextSetString (ptr->callTF, "");
      XmProcessTraversal (ptr->callTF, XmTRAVERSE_CURRENT);
   }


   /*
    * callCB - value changed and modify/verify callbacks puts
    * "His Call" into shared memory
    */
   void Callbox::callCB (Widget w, XtPointer cdata, XtPointer cbs)
   {
      int i;
      char *hisCall;
      XmTextVerifyCallbackStruct *ptr = (XmTextVerifyCallbackStruct *)cbs;

      switch (ptr->reason)
      {
         case (XmCR_VALUE_CHANGED):
            /* Get the call and put it in the shared memory */
            hisCall = XmTextGetString (w);
            strncpy ((char *)shareCall, hisCall, SHMSIZE);  /* put it in shm */
            break;

         case (XmCR_MODIFYING_TEXT_VALUE):
            /* change everything to uppercase */
            for (i = 0; i < ptr->text->length; i++)   /* all to upper case */
            {
               ptr->text->ptr[i] = toupper (ptr->text->ptr[i]);
            }
            break;
      }
      XmProcessTraversal (w, XmTRAVERSE_CURRENT);
   }
