<?php
/**
 *
 * Copyright 2001 - 2003 by Gero Kohnert
 *
 * @modulegroup watchlist
 * @package watchlist
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("watchlist","overview");
 loadmodule("watchlist");

 /**
  * show a overview of watchers
  */
 class watchlist_overview extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     $wl = new watchlist($this->dbconn);
     $r = $this->dbconn->Exec($this->q);
     $n = $r->numrows();
     if ( 0 == $n) {
       echo $this->error($lang['Err0048']);
       $r->free();
       return;
     }

     $this->assign("action", "watchlist_overview.php");

     if( $this->id != -1 ) {
       $cols  = 3;
       $title = $lang[$this->obj->getType()];
     }
     else if( $this->adr != -1 ) {
       $cols  = 4;
       $title = $lang['Watcher'];
     }
     else {
       $cols = 5;
     }

     /**
      * Set headers
      */ 
     $headers = array();

     if( $this->id == -1 ) {
       $headers[] = array('label' => "Type");
       $headers[] = array('label' => "ID");
     }
     if( $this->adr == -1 ) {
       $headers[] = array('name' => 'adr_id', 'label' => $lang['Watcher']);
     }
     $headers[] = array('name' => 'creation', 'label' => $lang['created']);
     $headers[] = array('name' => 'lastcall',
			'label' => $lang['WatchLastCall']);

     if( $tutos[massupdate] ) $cols++;

     $this->assign('cols', $cols);
     $this->assign('innercols', $cols - 2);
     $this->assign('title', $title);
     $this->assign('massupdate', $tutos[massupdate]);
     $this->assign('headers', $headers);

     if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     }
     else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }

     // Navigation bar
     $this->assign_navbar($a, $end, $n, $this->filter);

     $watchlist = array();

     $line = 0;
     while ( ($a < $n) && ($a < $end) ) {
       $oid = $r->get($a, "obj_id");
       $aid = $r->get($a, "adr_id");
       $obj = getObject($this->dbconn,$oid);
       $aobj = getObject($this->dbconn,$aid);

       $remove = false;
       $entry = array();

       if ( $this->id == -1 ) {
         if ( $obj == -1 ) {
	   $entry['id'] = $oid;
	   $entry['obj'] = array('label' => $lang['HistoryDeleted'],
				 'title' => $lang['HistoryDeleted'],
				 'link'  => "history_show.php?id=".$oid);

           $remove = true;
         }
	 else {
	   $entry['type']   = $lang[$obj->getType()];
	   $entry['obj'] = array('id'    => $oid,
				 'label' => $obj->getFullName(),
				 'title' => $obj->getFullName(),
				 'link'  => $obj->getUrl());

         }
       }

       // echo " <td nowrap align=\"right\">";
       if ( $aobj == -1 ) {
	 $entry['adr'] = array('label' => $lang['HistoryDeleted'],
			       'title' => $lang['HistoryDeleted'],
			       'link'  => "history_show.php?id=".$aid);
	 $remove = true;
       }
       else {
	 $entry['adr'] = array('id'    => $aid,
			       'label' => $aobj->getFullName(),
			       'title' => $aobj->getFullName(),
			       'link'  => $aobj->getUrl());
       }

       $creation = $r->getDateTime($a, "creation");
       $lastcall = $r->getDateTime($a, "lastcall");
       $entry['creation'] = $creation->getDateTime();
       $entry['lastcall'] = $lastcall->getDateTime();

       $entry['remove']   = $remove;
       $entry['check']    = !$remove
	  && (($this->user->id == $aid) || (($obj != -1 ) && $obj->mod_ok()));

       if ( $remove) {
	 $wl->remove($oid,$aid);
       }
       $watchlist[] = $entry;

       $a++;
     }
     // $this->debug($watchlist);
     $this->assign('watchlist', $watchlist);

     // Mass update bug solver
     $actions = array();
     $actions[-1] = $lang['ActionNil'];
     $actions[-2] = $lang['WatchDel'];
 
     $this->assign("actions", $actions);
     $this->assign('Enter',   $lang['Enter']);
     $this->assign('withmarked',
		   sprintf($lang['withmarked'], $lang['entry']));

     $this->template("watchlist/watchlist_overview");
   }


   /**
    * action
    */
   Function action() {
     global $msg, $lang;

     error_log('ACTION '.$_POST['mark']);

     @reset($_POST['mark']);
     if ( $_POST['action'] == -2 ) {
       $this->dbconn->Begin("WORK");
       $w = new watchlist($this->dbconn);
       foreach ($_POST['mark'] as $val) {
         $a = split(',',$val);
	 error_log("  ". $val ." ". $a[0] ." ". $a[1]);
         $b = getObject($this->dbconn,$a[0]);
	 if ( ! is_subclass_of($b,'tutos_base') ) {
           $msg .= "Unknown object: ". $a[0];
           continue;
	 }
         if ( $b->id != $a[0] ) {
           $msg .= "Unknown object: ". $a[0];
           continue;
         }
	 if ( ($this->user->id != $a[1]) && (! $b->mod_ok()) ) {
           $msg .=
	      sprintf($lang['Err0024'], $lang[$b->getType()]) .
	      " (". $b->getFullName() .")<br>";
           continue;
	 }
	 error_log(" ". $b->getFullName());
         $msg .= $w->remove($a[0],$a[1]);
         unset($b);
       }
       $this->dbconn->Commit("WORK");
     }

     /**
      * Now get back to the task_overview with its parameters properly
      * set
      */
     $params = array('id', 'adr');
     
     $gotourl = "watchlist_overview.php";
     foreach( $params as $p ) {
       if( isset($_REQUEST[$p]) && $_REQUEST[$p] != -1 )
	 $gotourl = addUrlParameter($gotourl, $p."=".$_REQUEST[$p], true);
       }

     Header("Status: 302 Moved Temporarily");
     Header("Location: ". getBaseUrl() . $gotourl);
   }

   /**
    * navigate
    */
   Function navigate() {
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['WatchOverview'];
     $this->link1 = "watchlist/watchlist_overview.php";
     $this->filter = array();
     $this->adr = -1;
     $this->id = -1;

     $this->q = "SELECT * FROM ". $this->dbconn->prefix ."watchlist ";
     $pre = "WHERE ";

     if ( isset($_GET['adr']) && ($_GET['adr'] != "") ) {
       # overview of things a person is watching for
       $this->adr = $_GET['adr'];
       $this->q .=" " . $pre ." adr_id = ". $this->adr;
       $pre = "AND ";
       $this->link1 = addUrlParameter($this->link1,"adr=".$this->adr);
       $this->obj = getObject($this->dbconn,$this->adr);
     }
     if ( isset($_GET['id']) && ($_GET['id'] != "") ) {
       # overview of persons watching for something
       $this->id = $_GET['id'];
       $this->q .= " " . $pre ." obj_id = ". $this->id;
       $pre = "AND ";
       $this->link1 = addUrlParameter($this->link1,"id=".$this->id);
       $this->obj = getObject($this->dbconn,$this->id);
       # check permission
       if ( ! $this->obj->mod_ok()) {
         $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
     }

     $this->assign('id', $this->id);
     $this->assign('adr', $this->adr);
     $this->assign('xf', $_GET['xf']);
     $this->assign('xo', $_GET['xo']);

     check_dbacl( $this->q, $this->user->id, "obj_id");

     # sorting
     $this->link2 = $this->link1;
     $xxx = "";
     order_parse($this->q,$this->link1,$xxx,$xxx,"obj_id");
   }
 }

 $l = new watchlist_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: watchlist_overview.php,v 1.23.2.5 2005/03/10 15:36:12 tapoueh Exp $
    $Author: tapoueh $
-->