<?php
/**
 * Copyright 1999 - 2004 by Gero Kohnert
 *
 *
 *   CVS Info:  $Id: company_show.php,v 1.63.2.2 2004/09/15 09:06:15 tapoueh Exp $
 *   $Author: tapoueh $
 *
 * @modulegroup company
 * @module company_show
 * @package company
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'address_tools.p3';
 include_once 'appointment.pinc';
 include_once 'timetrack.pinc';
 include_once 'product.pinc';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("company","show");

 /**
  * display a company
  */
 class company_show extends layout {
   /**
    * display the info
    */
   Function info() {
     global $tutos,$lang;

     if ( $this->format == "xml" ) {
       $r = $this->obj->exportXML();
       echo $this->obj->exportXMLHeader(strlen($r));
       echo $r;
       return;
     }

     /*
     if ( isset($this->obj->location) ) {
       $cols = count($this->obj->location);
     } else {
       $cols = 0;
     }
     if ( $cols < 3 ) {
       $cols = 3;
     }
     */

     $this->assign('title', sprintf($lang['Showing'],
				    $lang[$this->obj->getType()]));

     $this->assign('company',
		   array('label' => $lang['Company'],
			 'value' => myentities($this->obj->name)));

     $this->assign('departments',
		   array('label'  => $lang['Departments'],
			 'values' => department::infolist($this->user,
							  $this->obj)));

     $locs = array();
     foreach($this->obj->location as $i => $l) { 
       $locs[] = $l->get_array();
     }
     $this->assign('locs', $locs);

     /*
     // No departments
     $ra = $this->dbconn->Exec($this->q);
     if ( $ra->numrows() > 0 ) {
       echo "<tr>\n";
       echo " <th colspan=\"". $cols ."\">". $lang['CompanyMembers'] ."</th>\n";
       echo "</tr>\n";
       echo "<tr>\n";
       echo " <td colspan=\"". $cols ."\">\n";

       address_overview($this,$ra,$this->ashow,$this->atool,"company_show.php");

       echo " </td>\n";
       echo "</tr>\n";
     }
     $ra->free();

     // Older Appointments
     appointment::infolist($this->user,$this->obj,$cols,$this->format);

     // Project Roles
     product::infolist($this->user,$this->obj,$cols,$this->format);

     // References to modules
     show_module_infolists($this->user,$this->obj,$cols,$this->format);

     echo $this->obj->getHistoryLink($cols);
     echo $this->DataTableEnd();
     */

     $this->template('company_show');
   }

   /**
    * action via massupdate
    */
   Function action() {
     global $lang,$msg;

     foreach ($_GET['mark'] as $key => $val) {
       $b = new tutos_address($this->dbconn);
       $b->read($val);
       if ( $b->id != $val ) {
         continue;
       }
       if ( $_GET['action'] == -2 ) {
         $this->dbconn->Begin("WORK");
         $this->dbconn->Commit("WORK");
       }
     }
     if (class_exists('watchlist')) {
       watchlist::parse_action($this->user);
     }

     if ( $_GET['action'] == -4 ) {
       $this->redirect = acl_action();
     }
   }

   /**
    * Navigation
    */
   Function navigate() {
   }

   /**
    * Prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['CompanyDetail'];
     $this->obj = new company($this->dbconn);

     if (!isset($_GET['id'])) {
       $msg .= "Missing ID";
       $this->stop = true;
     } else {
       $this->obj->read($_GET['id']);
       $this->obj->read_locs_data();
       // $this->addHidden("id",$this->obj->id);

       $this->assign('id', $this->obj->id);
     }

     # Handling of department member list

     adr_tool_init($this->atool,$this->ashow);

     $this->ashow['f_name'] = 1;
     $this->ashow['l_name'] = 1;
     $this->ashow['email'] = 1;
     $this->ashow['phone'] = 1;
     $this->ashow['desc1'] = 1;

     $this->atool['link1'] = "company_show.php";
     $this->atool['link2'] = "company_show.php";

     $this->atool['link1'] = addUrlParameter($this->atool['link1'],"id=". $this->obj->id);
     $this->atool['link2'] = addUrlParameter($this->atool['link2'],"id=". $this->obj->id);

     $this->q = "SELECT distinct(a.id) , a.* FROM ". $this->dbconn->prefix ."addresses a, ". $this->dbconn->prefix ."location l, ". $this->dbconn->prefix ."adrloc r WHERE l.c_id = ". $this->obj->id ." AND a.id = r.adr_id AND r.loc_id = l.id AND ( l.d_id is null OR l.d_id = -1 ) ";

     if ( isset($_GET['xf']) && isset($_GET['xo']) ) {
       $this->q .= " ORDER by " . $_GET['xf'];
       if ( $_GET['xo'] == 1 ) {
         $this->q .= " ASC ";
       } else {
         $this->q .= " DESC ";
       }
       $this->atool['link1'] = addUrlParameter($this->atool['link1'],"xf=".UrlEncode($_GET['xf']));
       $this->atool['link1'] = addUrlParameter($this->atool['link1'],"xo=".$_GET['xo']);
     } else {
       $this->q .= " ORDER by l_name";
     }

     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( $this->obj->id < 0 ) {
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }

     if ( $this->obj->id > 0 ) {
       $this->name .= ": ". myentities($this->obj->getFullName());
     }


     // menu
     $x = tutos_address::getSelectLink($this->user,$lang['Search']);
     $this->addMenu($x);
     if ( $this->user->feature_ok(useaddressbook,PERM_NEW) ) {
       $x = array('url'   => "company_new.php",
                  'text'  => $lang['NewEntry'],
                  'info'  => $lang['CompanyCreateInfo'],
		  'image' => 'new',
                  'category' => array("company","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
       $x = array('url'   => $this->obj->getModURL(),
                  'text'  => $lang['Modify'],
                  'info'  => sprintf($lang['CompanyChgInfo'],
				    $this->obj->getFullName()),
		  'image' => 'modify',
                  'category' => array("company","mod","obj")
                 );
       $this->addMenu($x);
     }

     $x =  department::getaddlink($this->user,$this->obj);
     $this->addMenu($x);
     if ( class_exists( 'appointment') ) {
       $x = appointment::getaddlink($this->user,$this->obj);
       $this->addMenu($x);
     }
     if ( class_exists( 'checklist') ) {
       $x = checklist::getaddlink($this->user,$this->obj);
       $this->addMenu($x);
     }
     add_module_addlinks($this,$this->obj);

     // add this page to the browsehistory of the users session
     // $this->addtohistory();
   }
 }

 $l = new company_show($current_user);
 $l->display();
 $dbconn->Close();
?>