<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup address
 * @module address_select
 * @package address
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 require_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("address","select");

 /**
  * display a address selection form
  */
 class address_select extends layout {
   /**
    *
    */
   Function info() {
     global $lang, $tutos;

     $this->assign('action', "address_overview.php");
     $this->assign('ext', $this->ext);

     $this->assign('title', $lang['SearchForAdr']);
       
     $this->assign('name',
		   array('id'    => 'name',
			 'label' => $lang['AdrName'],
			 'value' => $this->lookfor));
     
     $this->assign('search',
		   array('label' => $lang['Search'],
			 'title' => $lang['SearchForAdr']));
     
     $this->assign('extlink',
		   array('label' => $lang['extended'],
			 'link'  => "address_select.php?ext=1",
			 'title' => $lang['extended']));

     
     // Company search
     $this->assign('c_action', "company_overview.php");
     $this->assign('c_title', $lang['SearchForCmp']);
     $this->assign('c_name',
		   array('id'    => 'name',
			 'label' => $lang['AdrName'],
			 'value' => $this->lookfor));
     
     $this->assign('c_search',
		   array('label' => $lang['Search'],
			 'title' => $lang['SearchForAdr']));

     
     $this->template('address_select');
   }

   /**
    * Menu navigation
    */
   Function navigate() {
     global $lang;

     // menu
     if ( $this->user->feature_ok(useaddressbook, PERM_NEW) ) {
       $x = array('url'   => "address_new.php",
                  'text'  => $lang['NewEntry'],
                  'info'  => $lang['AdrCreateInfo'],
		  'image' => 'new',
                  'category' => array("address","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( $this->user->feature_ok(useaddressbook, PERM_NEW) ) {
       $x = array('url'   => "company_new.php",
                  'text'  => $lang['CompanyCreate'],
                  'info'  => $lang['CompanyCreateInfo'],
		  'image' => 'new',
                  'category' => array("company","new","obj")
                 );
       $this->addMenu($x);

       /*
       $x = array('url'  => "department_new.php",
                  'text' => $lang['DepartmentCreate'],
                  'info' => $lang['DepCreateInfo'],
                  'category' => array("department","new","obj")
                 );
       $this->addMenu($x);
       */
     }
   }

   /**
    * preapre everything read data , parse args etc
    */
   Function prepare() {
     global $msg,$lang,$tutos;
     $this->name = $lang['AddressSearch'];

     if ( ! $this->user->feature_ok(useaddressbook,PERM_SEL) ) {
       $msg .= sprintf($lang['Err0022'],"'". $this->name ."'");
       $this->stop = true;
     }

     # The extended mode fields
     if ( isset($_SESSION['adrsearch']) ) {
       $tutos[adrsearch] = $_SESSION['adrsearch'];
     }
     # The default search string
     if ( isset($_SESSION['adrlook']) ) {
       $this->lookfor = $_SESSION['adrlook'];
     } else {
       $this->lookfor = "";
     }
     if ( isset($_GET['ext']) ) {
       $this->ext = $_GET['ext'];
     } else {
       $this->ext = 0;
     }
     if ( isset($_SESSION['ldapserver']) ) {
       $this->ldapserver = $_SESSION['ldapserver'];
     } else {
       $this->ldapserver = 0;
     }
   }
 }

 $l = new address_select($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: address_select.php,v 1.35.2.3 2004/09/21 16:15:04 tapoueh Exp $
    $Author: tapoueh $
-->