<?php
/**
 * Copyright 2001 - 2003 by Gero Kohnert
 *
 * @modulegroup group
 * @module group_show
 * @package group
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("group","show");
 loadmodule("group");
 loadlayout();
 
 function member_sort(&$a,&$b) {
   if ( ($a->gettype() == 'company') && ($b->gettype() != 'company') ) {
     return 1;
   }
   if ( ($b->gettype() == 'company') && ($a->gettype() != 'company') ) {
     return -1;
   }
   # both are the same type, so we can compare
   return ($a->l_name < $b->l_name) ? -1 : 1;
 }
 

 /**
  * display a CRM group
  */
 class group_show extends layout {
   /**
    * the data display part
    */
   Function info() {
     global $tutos,$lang;

     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"7\">". sprintf($lang['Showing'],$this->obj->getFullName()) ."</th>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['createdby']);
     echo $this->showdata($this->obj->creator->getLink(),2);
     echo $this->showfield($lang['atDateTime']);
     echo $this->showdata($this->obj->creation->getDateTime(),3);

     echo "</tr><tr>\n";
     echo $this->showfield($lang['GroupName']);
     echo $this->showdata(myentities($this->obj->name),6);

     echo "</tr><tr>\n";
     echo $this->showfield($lang['GroupDesc']);
     echo $this->showdata(myentities($this->obj->desc),6);

     echo "</tr>\n";

     # References to modules
     show_module_infolists($this->user,$this->obj,7);

     $this->obj->read_member();
     if ( count($this->obj->member) > 0 ) {
       @reset ($this->obj->member);
       usort($this->obj->member,"member_sort");
       $first = true;
       echo "<tr>\n";
       echo $this->showfield($lang['GroupMember']);
       echo "<th>". $lang['AdrName']."</th>";
       echo "<th colspan=\"2\">". $lang['Description']."</th>";
       echo "<th>". $lang['AdrEmail']."</th>";
       echo "<th>". $lang['Phone']."</th>";
       echo "<th>". $lang['AdrFax']."</th>";
       echo "</tr>\n";
       $line = 1;
       while( list ($i,$f) = @each ($this->obj->member)) {
         echo $this->OverviewRowStart($line);
         echo "<td>&nbsp;</td>";
         $f->read_locs_data();
         $cnt =  count($f->location);
         if ( $cnt > 0 ) {
           @reset($f->location);
           echo "<td valign=\"top\" rowspan=\"". $cnt ."\">". $this->obj->member[$i]->getLink() ."</td>\n";
           $cnt2 = 0;
           while( list ($i2,$f2) = @each ($f->location)) {
             if ( $cnt2 > 0 ) {
               echo $this->OverviewRowEnd($line);
               echo $this->OverviewRowStart($line);
               echo "<td>&nbsp;</td>";
             }
             echo " <td>". $f2->lname ."&nbsp;</td>\n";
             echo " <td>". $f2->desc1 ."&nbsp;</td>\n";
             echo " <td>". asEmail($f2->email_1,$f2->email_1,$f2->getFullName());
             if ( $f2->email_2 != "" ) {
               echo "<br>". asEmail($f2->email_2,$f2->email_2,$f2->getFullName());
             }
             echo "&nbsp;</td>\n";
             echo " <td>". handle('phone',$f2,$f2->phone_1);
             if ( $f2->email_2 != "" ) {
               echo "<br>". handle('phone',$f2,$f2->phone_2);
             }
             echo "&nbsp;</td>\n";
             echo " <td>". handle('fax',$f2,$f2->fax_1) ."&nbsp;</td>\n";
             $cnt2++;
           }
         } else {
           echo "<td colspan=\"6\">". $this->obj->member[$i]->getLink() ."</td>\n";
         }
         echo $this->OverviewRowEnd($line++);
       }
     }
     echo $this->obj->getHistoryLink(7);
     echo $this->DataTableEnd();
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$tutos,$lang;

     $this->name = $lang['GroupDetail'];
     $this->obj = new group($this->dbconn);

     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
     }
     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( $this->obj->id < 0 ) {
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else {
       $this->name .=": ". $this->obj->getFullName();
     }
     # menu
     $m = group::getOverviewLink($this->user,$lang['Search']);
     $m[category][] = "obj";
     $this->addMenu($m);
     if ( $this->user->feature_ok(usegroups,PERM_NEW) ) {
       $x = array( url => "group/group_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['GroupCreate'],
                   category => array("group","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( $this->obj->mod_ok() ) {
       $x = array( url => "group/group_new.php?id=". $this->obj->id,
                   text => $lang['Modify'],
                   info => sprintf($lang['GroupModifyI'],$this->obj->getFullName()),
                   category => array("group","mod","obj")
                 );
       $this->addMenu($x);
     }
     $x = $this->obj->getMailLink();
     $this->addMenu($x);
     add_module_addlinks($this,$this->obj);

     # add this page to the browsehistory of the users session
     $this->addtohistory();
   }
 }

 $l = new group_show($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: group_show.php,v 1.25 2003/07/18 11:06:49 gokohnert Exp $
    $Author: gokohnert $
-->