<?php
/**
 * Copyright 2001 - 2002 by Gero Kohnert
 *
 * Make a ldap request and show results
 *
 * @modulegroup address
 * @module adr_ldap_overview
 * @package address
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'address_tools.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("ldap","overview");
 loadmodule("ldap");
 loadlayout();

 /**
  * display a address_overview
  */
 class ldap_overview extends layout {
   /**
    * name = search string
    * sv = server number (see config.pinc)
    */
   Function info() {
     global $lang , $tutos, $ashow;

     if ( ! $this->obj->connect() ) {
       echo $this->error($lang['LDAP_Err001']);
       return;
     }
     echo sprintf($lang['LDAPSearchFor'],$this->search,$this->obj->GetFullName()) ."<br>\n";
     
     $link2 = "ldap/ldap_overview.php?host=".$this->obj->host."&amp;port=".$this->obj->port;
     $justthese = array( "cn","c","o","ou","mail","*");

     // Search surname entry
     $sr = ldap_search($this->obj->ds,$this->obj->basedn,$this->filter,$justthese,0,40,20,LDAP_DEREF_ALWAYS);
	 echo "|".$this->obj->basedn ."|". $this->filter ."<br>";
     if (!$sr) {
       echo $this->error($this->obj->error());
       return;
     }

     $cnt = ldap_count_entries($this->obj->ds,$sr);

     if ( $cnt > 0 ) {
       echo sprintf($lang['LDAPFound'], $cnt) ."<p>\n";
       $info = ldap_get_entries($this->obj->ds, $sr);
       $this->obj->close();
     } else {
       echo $this->error($lang['Err0048']);
       $this->obj->close();
       return;
     }

     $cols = 0;
     echo $this->actionformStart("ldap_overview.php");
     echo $this->OverviewTableStart();
     echo "<thead>\n";
     echo "<tr>\n";
     if ( $ashow['f_name'] == 1 ) {
       echo "<th>". $lang['AdrFirstName']."</th>\n";
       $justthese[] = "givenname";
       $cols++;
     }
     if ( $ashow['l_name'] == 1 ) {
       echo "<th>". $lang['AdrLastName']."</th>\n";
       $justthese[] = "sn";
       $justthese[] = "surname";
       $cols++;
     }
     if ( $ashow['c_id'] == 1 ) {
       echo "<th>". $lang['Company']."</th>\n";
       $justthese[] = "o";
       $cols++;
     }
     if ( $ashow['d_id'] == 1 ) {
       echo "<th>". $lang['Department']."</th>\n";
       $justthese[] = "department";
       $justthese[] = "ou";
       $cols++;
     }
     if ( $ashow['email'] == 1 ) {
       echo "<th>". $lang['AdrEmail']."</th>\n";
       $justthese[] = "mail";
       $cols++;
     }
     if ( $ashow['city'] == 1 ) {
       echo "<th>". $lang['City']."</th>\n";
       $justthese[] = "l";
       $cols++;
     }

     echo "<th>". $lang['Country']."</th>\n";
     $cols++;

     if ( $ashow['phone'] == 1 ) {
       echo "<th>". $lang['Phone']."</th>\n";
       $justthese[] = "telephonenumber";
       $cols++;
     }
     if ( $ashow['fax'] == 1 ) {
       echo "<th>". $lang['AdrFax']."</th>\n";
       $justthese[] = "faxnumber";
       $justthese[] = "facsimiletelephonenumber";
       $cols++;
     }
     if ( $tutos[massupdate] == 1 ) {
       echo "  <th nowrap><input type=\"checkbox\" name=\"checkit\" onClick=\"CheckAll2();\"></th>\n";
     }
     echo "</tr>\n";
     echo "</thead>\n";

     $line = 0;
     echo "<tbody>\n";
     for ($i=0; $i<$info["count"]; $i++) {
       if (isset($tutos['ldap:'. $this->obj->host .":". $this->obj->port]['uniquekey']) ) {
         $keyname = $tutos['ldap:'.$this->obj->host.':'.$this->obj->port]['uniquekey'];
	   } else {
         $keyname = "dn";
	   }
       $key =  $info[$i][strtolower($keyname)];
       if (is_array($key)) {
         $key =  $info[$i][strtolower($keyname)][0];
       }
       if ($keyname != "dn") {
         $key = $keyname ."=". $key;
       }
#var_dump($key);
#       $link  = "ldap://". $tutos[ldapserver][$this->sv].":".$tutos[ldapport][$this->sv]."/". str_replace("\"","",$dn) ;
       $link  = addSessionKey("ldap_show.php?host=".$this->obj->host."&amp;port=".$this->obj->port ."&amp;key=".UrlEncode($key) );

       echo $this->OverviewRowStart($line);

       if ( $info[$i]["givenname"][0] == "" ) {
         if ( ($ashow['f_name'] == 1) || ($ashow['l_name'] == 1) ) {
           echo "<td colspan=\"2\"><a href=\"". $link ."\">". $this->obj->decode($info[$i]["cn"][0]) ."</a>&nbsp;</td>\n";
         }
       } else {
         if ( $ashow['f_name'] == 1 ) {
           echo "<td><a href=\"". $link ."\">". $this->obj->decode($info[$i]["givenname"][0]) ."</a>&nbsp;</td>\n";
         }
         if ( $ashow['l_name'] == 1 ) {
           if ( isset($info[$i]["surname"][0]) ) {
             echo "<td>". $this->obj->decode($info[$i]["surname"][0]) ."&nbsp;</td>\n";
           } else if ( isset( $info[$i]["sn"][0]) ) {
             echo "<td>". $this->obj->decode($info[$i]["sn"][0]) ."&nbsp;</td>\n";
           }
         }
       }
       // ORG and ORGUNIT
       if ( $ashow['c_id'] == 1 ) {
         echo "<td>". $this->obj->decode($info[$i]["o"][0]) ."&nbsp;</td>\n";
       }
       if ( $ashow['c_id'] == 1 ) {
         echo "<td>";
		 if (isset($info[$i]['ou'])) {
           echo makelink($link2. "&amp;ou=".UrlEncode($info[$i]["ou"][0]),$this->obj->decode($info[$i]["ou"][0]));
		 }
		 if (isset($info[$i]['department'])) {
           echo "<br>". makelink($link2. "&amp;department=".UrlEncode($info[$i]["department"][0]),$this->obj->decode($info[$i]["department"][0]));
         }
         echo "&nbsp;</td>\n";
       }
       if ( $ashow['email'] == 1 ) {
         // email
         echo "<td>\n";
         if (isset($tutos[$this->obj->getIndex()]['email_1'])) {
           $k = strtolower($tutos[$this->obj->getIndex()]['email_1']);
		   if ( isset($info[$i][$k]) ) {
             echo AsEmail($info[$i][$k][0],$info[$i][$k][0],$info[$i]["givenname"][0]);
		   }
		 }
         echo "&nbsp;</td>\n";
       }
       if ( $ashow['city'] == 1 ) {
         echo "<td>";
         if (isset($tutos[$this->obj->getIndex()]['city'])) {
           $k = strtolower($tutos[$this->obj->getIndex()]['city']);
           echo handle('city',$info[$i],$this->obj->decode($info[$i][$k][0]));
         } else if (isset($tutos[$this->obj->getIndex()]['l'])) {
           echo handle('city',$info[$i],$this->obj->decode($info[$i]["l"][0]));
		 }
         echo "&nbsp;</td>\n";
       }
       echo "<td>";
       if ( isset($info[$i]["c"][0]) ) {
         echo $info[$i]["c"][0];
       }
       echo "&nbsp;</td>\n";
       if ( $ashow['phone'] == 1 ) {
         echo "<td>\n";
         if ( isset($info[$i]["telephonenumber"][0]) ) {
           echo $info[$i]["telephonenumber"][0];
         }
         echo "&nbsp;</td>\n";
       }
       if ( $ashow['fax'] == 1 ) {
         echo "<td>\n";
         if ( isset($info[$i]["faxnumber"][0]) ) {
           echo handle('fax',$info,$info[$i]["faxnumber"][0]);
         } else if ( isset($info[$i]["facsimiletelephonenumber"][0]) ) {
           echo handle('fax',$info,$info[$i]["facsimiletelephonenumber"][0]);
         }
         echo "&nbsp;</td>\n";
       }
       if ( $tutos[massupdate] == 1 ) {
         echo " <td align=\"center\">\n";
         echo "  <input name=\"mark[]\" type=\"checkbox\" value=\"". $key ."\">\n";
         echo " </td>\n";
       }
       echo $this->OverviewRowEnd($line++);
     }
     echo "</tbody>\n";
     if ( $tutos[massupdate] == 1 ) {
       echo $this->UpdateRowStart($cols -2);
       echo sprintf($lang['withmarked'],$lang['Address']);
       echo "<select name=\"action\">\n";
       echo " <option value=\"-1\" selected>". $lang['ActionNil'] ."</option>\n";
       echo " <option value=\"-2\">". $lang['LDAPImport']."/". $lang['LDAPUpdate'] ."</option>\n";
       echo "</select>\n";
       echo $this->UpdateRowEnd(3);
     }
     echo $this->OverviewTableEnd();
     echo $this->actionformEnd("ldap_overview.php");
   }
   /**
    * action via massupdate
    */
   Function action() {
     global $msg,$lang;

     $l = new ldap($this->dbconn);
     if ( isset($_GET['sv']) ) {
       # remember this
       $l->setserver($_GET['sv']);
     }
     if ( isset($_GET['host']) ) {
       $l->sethost($_GET['host'],$_GET['port']);
     }
     if ($l->host == "") {
       return;
     }
     if ( ! $l->connect() ) {
       return;
     }

     if ( $_GET['action'] == -2 ) {
       $this->dbconn->Begin("WORK");
       foreach ($_GET['mark'] as $key => $val) {
         $adr = $l->import($val);
		 if ($adr != -1) {
           $msg .= "synced : ". $adr->getFullName() ."<br>";
		 }
       }
       $this->dbconn->Commit("WORK");
	 }
     $l->close();
   }
   /**
    * naviagte
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$tutos,$lang;

     $this->name = $lang['LDAPOverview'];
     $this->obj = new ldap($this->dbconn);
     if ( isset($_GET['sv']) ) {
       # remember this
       $_SESSION['ldapserver'] = $_GET['sv'];
       $this->obj->setserver($_GET['sv']);
     }
     if ( isset($_GET['host']) && isset($_GET['port'])) {
       $this->obj->sethost($_GET['host'],$_GET['port']);
     }
     if ($this->obj->host == "") {
       $msg .= "NO Server defined !";
       $this->stop = true;
     }
     $this->addHidden("host",$this->obj->host);
     $this->addHidden("port",$this->obj->port);
     if ( isset($_GET['department']) ) {
       $this->filter="(|(department=". $_GET['department'] .")(ou=". $_GET['department'] ."))";
       $this->search = $_GET['department'];
       $this->addHidden("department",$_GET['department']);
     } else
     if ( isset($_GET['ou']) ) {
       $this->filter="(|(ou=". $_GET['ou'] ."))";
       $this->search = $_GET['ou'];
       $this->addHidden("ou",$_GET['ou']);
     } else
     if ( isset($_GET['name']) ) {
       # remember this
       $_SESSION['adrlook'] = $_GET['name'];
       $name = $_GET['name'];
       $n =str_replace(" ","*",$name);
       $n = $n . "*";
       $this->filter="(|(sn=". $n .")(givenname=". $n .")(cn=". $n ."))";
       $this->search = $n;
       $this->addHidden("name",$name);
     } else {
       $msg .= "NO Searchstring defined !";
       $this->stop = true;
     }
     if ( ! $this->user->feature_ok(useldap,PERM_SEE) ) {
       $msg .= "LDAP disabled";
       $this->stop = true;
     }
     # menu
     $x = tutos_address::getSelectLink($this->user,$lang['Search']);
     $this->addMenu($x);
     if ( $this->user->feature_ok(useaddressbook,PERM_NEW) ) {
       $x = array( url => "address_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['AdrCreateInfo'],
                   category => array("address","new","obj")
                 );
       $this->addMenu($x);
     }
     # close the session in order to handle ldap timeouts
     session_write_close();
   }
 }


 $ashow['f_name'] = 1;
 $ashow['l_name'] = 1;
 $ashow['email'] = 1;
 $ashow['phone'] = 1;
 $ashow['fax'] = 1;
 $ashow['city'] = 1;
 $ashow['c_id'] = 1;
 $ashow['d_id'] = 1;
 $atool['maxshow'] = $tutos[maxshow];
 if ( (! isset($atool['start'])) || ($atool['start'] < 0) ) {
   $atool['start'] = 0;
 }

 $l = new ldap_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: ldap_overview.php,v 1.11 2003/11/06 21:22:20 gokohnert Exp $
    $Author: gokohnert $
-->
