<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup timetrack
 * @module timetrack_new
 * @package timetrack
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'timetrack.pinc';
 include_once 'task.pinc';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("timetrack","new");

 /**
  * change/modify a timetrack entry
  */
 class timetrack_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $lang, $tutos,$table;

     if ( $this->mode == 1 ) {
       # if we are in time record mode we first give a list of all OPEN records
       $q = "SELECT * from ". $this->obj->tablename ." WHERE t_start is not null AND t_end is NULL and adr_id = ". $this->obj->worker->id;
       $r = $this->dbconn->Exec($q);
       $n = $r->numrows();
       $a = 0;
       if ( $n > 0 ) {
         echo $this->DataTableStart();
         echo "<tr>\n";
         echo "<th>". $lang['Timetrack'] ."</th>\n";
         echo "<th>". $lang['AppStart'] ."</th>\n";
         echo "<th>". $lang['TimetrackRef'] ."</th>\n";
         echo "<th>". $lang['TimetrackModify'] ."</th>\n";
         echo "<th>". $lang['TTfinish'] ."</th>\n";
         echo "</tr>\n";
       }
       $line = 0 ;
       while ( $a < $n ) {
         $f = new timetrack($this->dbconn);
         $f->read_result($r,$a);
         $a++;
         echo $this->OverviewRowStart($line);
         echo "<td>". $f->getLink() ."</td>";
         echo "<td>". $f->t_start->getDateTime() ."</td>";
         echo "<td>". $f->ref->getLink() ."</td>";
         echo "<td>". makelink("timetrack_new.php?mode=2&id=". $f->id,$lang['Modify'],$lang['TimetrackModify']) ."</td>";
         echo "<td>". makelink("timetrack_finish.php?id=". $f->id,$lang['TTfinish'],$lang['TTfinish']) ."</td>";
         echo $this->OverviewRowEnd($line++);
       }
       $r->free();
       if ( $n > 0 ) {
         echo $this->DataTableEnd();
         return;
       }
     }

     /**
      * Here begins the template stuff
      *
      * Note for the moment just one mode is implemented, other ways
      * of displaying a timetrack are to be reviewed before to be
      * re-implemented  as is  in the v2.
      */

     $this->assign('action', 'timetrack_ins.php');
     $this->assign('mode', $mode);
     $this->assign('id', $this->obj->id);
     $this->assign('lid', $this->obj->ref->id);

     $this->assign('hours', $lang['hours']);

     if( ($this->obj->ref != -1)
	  && ($this->obj->ref->gettype() != "address") ) {

       $parents = array();
       $x = $this->obj->ref;
       while ( isset ( $x ) ) {
         // echo $pre . $lang[$x->gettype()] . "&nbsp;" . $x->getLink();
	 $parents[] = array('label' => $x->getFullName(),
			    'title' => $x->getFullName(),
			    'link'  => $x->getUrl(),
			    'type'  => $lang[$x->gettype()]);

         if( isset($x->parent) && $x->parent != -1 )
           $x = $x->parent;
         else
           unset($x);
       }
       // $this->debug($parents);
       $this->assign('parents',
		     array('label'   => $lang['TaskSubTask'],
			   'parents' => $parents));
     }

     $this->assign('ref',
		   array('id'    => $this->obj->ref->id,
			 'label' => $lang['TimetrackRef'],
			 'value' => $this->obj->ref->getFullName(),
			 'title' => $this->obj->ref->getFullName(),
			 'link'  => $this->obj->ref->getUrl()));

     $this->assign('worker',
		   array('id'    => 'w',
			 'name'  => "wfn",
			 'label' => $lang['TimetrackWorker'],
			 'value' => $this->obj->worker->getFullName(),
			 'title' => $this->obj->worker->getFullName(),
			 'link'  => $this->obj->worker->getUrl()));
				   

     $this->assign('volume_done',
		   array('name'  => 'volume',
			 'label' => $lang['TaskVolumeDone'],
			 'value' => number_format($this->obj->volume, 2,
						  $lang['DecPoint'],
						  $lang['ThousandPoint'])));

     $this->assign_date($lang['atDateTime'], "wd", $this->obj->wday);

     $this->assign('ref_type', $this->obj->ref->getType());

     if( $this->obj->ref->getType() == "task" ) {
       if( $this->obj->ref->volume_todo == -1 )
         $volume_todo = $this->obj->ref->volume - $this->obj->ref->volume_done;
       else
         $volume_todo = $this->obj->ref->volume_todo;


       // give a check box for the user to choose to indicate volume
       // done or to ask the system to calculate it
       $this->assign('calc_volume_todo',
		     array('id'    => 'calc_volume_todo',
			   'label' => $lang['TaskVolumeTodoC'],
			   'value' => 0));

       $this->assign('volume_todo',
		     array('name'  => 'volume_todo',
			   'label' => $lang['TaskVolumeTodo'],
			   'value' => $volume_todo));
     }

     $this->assign('useinvoice', $tutos[useinvoice]);
     if( $tutos[useinvoice] == 1 ) {
       $this->assign('currency',
		     array('id'       => 'cph',
			   'name'     => 'currency',
			   'label'    => $lang['TTcph'],
			   'value'    => number_format($this->obj->cph, 2,
						       $lang['DecPoint'],
						       $lang['ThousandPoint']),
			   'options'  => $tutos[currencies],
			   'currency' => $this->obj->currency));
       
       $this->assign('state',
		     array('id'      => 'id',
			   'name'    => 'state',
			   'label'   => $lang['TTState'],
			   'value'   => $this->obj->state,
			   'options' => $lang['TTStates']));
     }

     $this->assign('desc',
		   array('name'  => 'desc',
			 'label' => $lang['Description'],
			 'value' => $this->obj->desc,
			 'size'  => $table['timetrack']['description'][size]));

     $this->assign('InputOk',   $lang['InputOk']);
     $this->assign('ChangesOk', $lang['ChangesOk']);
     $this->assign('Enter', $lang['Enter']);
     $this->assign('Reset', $lang['Reset']);

     $this->assign('focus', "ttadd.name");

     $this->assign('FldsRequired', $lang['FldsRequired']);

     $this->template('timetrack_new');
   }

   /**
    * navigate
    */
   Function navigate() {
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg,$tutos,$lang;
     #
     # Mode
     # 0 = classical Timetrack
     # 1 = timerecord with a list of open entries
     # 2 = timerecord editable
     #
     if ( isset($_GET['mode']) ) {
       $this->mode = $_GET['mode'];
     } else {
       $this->mode = 0;
     }
     $this->obj = new timetrack($this->dbconn);
     if ( isset($_GET['id']) && ($_GET['id'] > 0) ) {
       # existing timetrack
       $this->obj->read($_GET['id']);
       if ( ($this->obj->t_start->notime == 0) && ( $this->mode != 2) ) {
         $this->mode = 1;
       }
       if ( ($this->obj->id < 0) ) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
     } else {
       # new stuff
       if ( $this->mode == 1 ) {
         $this->obj->t_start = new DateTime();
       }
       $this->obj->ref = $this->user;
     }
     $this->obj->read_relations();

     if ( ($this->obj->id < 0) && !$this->user->feature_ok(usetimetrack,PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     if ( $this->mode != 0 ) {
       $this->name = $lang['TTRecord'];
     } else if ( $this->obj->id > 0 )  {
       $this->name = $lang['TimetrackModify'];
     } else {
       $this->name = $lang['TimetrackNew'];
     }

     if ( isset($_GET['reftype']) ) {
       $this->obj->reftype = StripSlashes($_GET['reftype']);
     } else {
       $this->obj->reftype = "";
     }
     if ( isset($_GET['desc']) ) {
       $this->obj->desc = StripSlashes($_GET['desc']);
     }
     if ( isset($_GET['volume']) ) {
       $this->obj->volume = $_GET['volume'];
     }
     if ( isset($_GET['state']) ) {
       $this->obj->state = $_GET['state'];
     }
     if ( isset($_GET['cph']) ) {
       $this->obj->cph = $_GET['cph'];
     }
     if ( isset($_GET['currency']) ) {
       $this->obj->currncy = $_GET['currency'];
     }
     if ( isset($_GET['wd']) ) {
       $this->obj->wday->setDateTime($_GET['wd']);
     }
     if ( isset($_GET['start']) ) {
       $this->obj->t_start->setDateTime($_GET['start']);
     }
     if ( isset($_GET['end']) ) {
       $this->obj->t_end->setDateTime($_GET['end']);
     }

     preset_from_array_or_input($this->obj,'worker',"w");
     preset_from_array_or_input($this->obj,'ref',"l");

	 if ($this->obj->ref == -1) {
       $this->obj->link_id = -1;
	 } else {
       $this->obj->link_id = $this->obj->ref->id;
	 }
     if ( $this->obj->link_id == -1 ) {
       $msg .= "Unknown reference";
       $this->stop = true;
     }

     # menu
     $x = timetrack::getSelectLink($this->user);
     $x['category'][] = "obj";
     $x['image'] = "search";
     $this->addmenu($x);

     $x = timetrack::getaddlink($this->user,$this->obj->ref);
     $this->addMenu($x);

     if ( ($this->obj->id > 0)
	  && $this->obj->del_ok() && ($this->obj->ref >0 ) ) {
       $x = array('url'  => $this->obj->getDelURL(),
                  'text' => $lang['Delete'],
                  'info' => sprintf($lang['TimetrackDelI'],
				    $this->obj->ref->getFullname()),
		  'image' => 'delete',
                  'confirm' => true,
                  'category' => array("timetrack","del","obj")
                 );
       $this->addMenu($x);
     }

     if ( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
       $x = array( 'url'   => "acl_show.php?id=".$this->obj->id,
                   'text'  => $lang['AclDetail'],
		   'image' => 'acls',
                   'info'  => sprintf($lang['AclDetailI'],
				      $this->obj->getFullname()),
                   'category' => array("timetrack", "acl","obj")
                 );
       $this->addMenu($x);
     }
     add_module_newlinks($this,$this->obj);
     
     // read the rates possible for this new timetrack
     if ( class_exists ("rate") ) {
       rate::obj_read($this->obj);
     }

     web_StackStartLayout($this,"timetrack_new.php","timetrack_new.php?".$_SERVER['QUERY_STRING']);          
   }
 }

 $l = new timetrack_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: timetrack_new.php,v 1.50.2.10 2005/03/09 16:28:16 tapoueh Exp $
    $Author: tapoueh $
-->