<?php
/**
 * Copyright 2001 - 2003 by Gero Kohnert
 *
 * @modulegroup resource
 * @module resource_new
 * @package resource
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("resource","new");
 loadmodule("resource");
 loadlayout();
 /**
  * display a resource create/modify form
  */
 class resource_new extends layout {
   /**
    *
    */
   Function info() {
     global $tutos,$lang,$table;

     echo "<form name=\"resnew\" action=\"resource_ins.php\" method=\"POST\">\n";
     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"4\">".  sprintf($lang['Showing'],$lang[$this->obj->getType()])."</th>\n";
     echo "</tr>\n";
     if ($this->obj->id > 0 ) {
       $this->addHidden("id",$this->obj->id);
       echo "<tr>\n";
       echo " <td colspan=\"3\">". sprintf ($lang['BugCreation'],$this->obj->creator->getLink(),$this->obj->creation->getDateTime()) ."</td>\n";
       echo " <td align=\"right\">". acl_link($this->obj) ."</td>\n";
       echo "</tr>\n";
     }
     echo "<tr>\n";
     echo $this->showfieldc($lang['ResName'],1,"name");
     echo " <td colspan=\"3\" valign=\"top\"><input size=\"". min($table['resource']['name'][size],30) ."\" maxlength=\"". $table['resource']['name'][size] ."\" name=\"name\" value=\"". myentities($this->obj->name) ."\"></td>";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['ResDesc'],0,"desc");
     echo " <td colspan=\"3\" valign=\"top\"><input size=\"". min($table['resource']['description'][size],40) ."\" maxlength=\"". $table['resource']['description'][size] ."\" name=\"desc\" value=\"". $this->obj->desc ."\"></td>";
     echo "</tr>\n";

     # References to modules
     module_addforms($this->user,$this->obj,4);

     if ( $this->obj->mod_ok() != 0 ) {
       echo "<tr>\n";
       if ($this->obj->id > 0 ) {
         submit_reset(0,1,1,1,1,0);
       } else {
         submit_reset(0,-1,1,1,1,0);
       }
       echo "</tr>\n";
     }
     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
     echo $this->setfocus("resnew.name");
     echo $lang['FldsRequired'] ."\n";
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->obj = new resource($this->dbconn);

     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
       if ( $this->obj->id < 0 ) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true ;
       } else {
         $this->name = $lang['ResModify'] .": ". myentities($this->obj->getFullName());
       }
     } else {
       $this->name = $lang['ResCreate'];
     }

     if ( isset($_GET['name']) ) {
       $this->obj->name = StripSlashes($_GET['name']);
     }
     if ( isset($_GET['desc']) ) {
       $this->obj->desc = StripSlashes($_GET['desc']);
     }
     if (($this->obj->id < 0) && !$this->user->feature_ok(useresource,PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if (! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     # menu
     $m = resource::getOverviewLink($this->user,$lang['Resources']);
     $m[category][] = "obj";
     $this->addMenu($m);
     if ( ($this->obj->id != -1) && $this->obj->del_ok() ) {
       $m = array( url => $this->obj->getDelURL(),
                   text => $lang['Delete'],
                   info => sprintf($lang['ResDelI'],$this->obj->getFullname()),
                   confirm => true,
                   category => array("resource","del","obj")
                 );
       $this->addMenu($m);
     }
     add_module_newlinks($this,$this->obj);
   }
 }

 $l = new resource_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: resource_new.php,v 1.20 2004/01/20 16:14:05 gokohnert Exp $
    $Author: gokohnert $
-->