<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup file
 * @module file_overview
 * @package file
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('file','overview');
 loadmodule('file');
 loadlayout();

 /**
  * show a overview of files
  */
 class file_overview extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     $n = $this->result->numrows();

     if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     } else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }

     echo $this->OverviewTableStart();
     echo "<thead>\n";
     echo "<tr>\n";
     echo $this->orderHeader("name",$lang['FileNameDoc'],$this->link2);
     echo $this->orderHeader("version",$lang['FileVersion'],$this->link2);
     echo $this->orderHeader("filename",$lang['FileName'],$this->link2);
     echo $this->orderHeader("",$lang['FileReference'],$this->link2);
     echo $this->orderHeader("f_size",$lang['FileSize'],$this->link2);
     echo $this->orderHeader("creation",$lang['created'],$this->link2);
     echo "</tr>\n";
     echo "</thead>\n";

     echo "<tbody>\n";
     $line = 0;
     while ( ($a < $n) && ($a < $end) ) {
       $f = new tutos_file($this->dbconn);
       $f->read_result($this->result,$a);
       $f->read_reference();

       echo $this->OverviewRowStart($line);
       $x = myentities($f->name);
       if ( $this->filter['name'] != "" ) {
         $x = eregi_replace("(". $this->filter['name'] .")","<span class=\"found\">\\1</span>",$x);
       }
       if ( $f->see_ok() ) {
         echo " <td>". makelink($f->getUrl(),$x) ."</td>\n";
       } else {
         echo " <td>". $x ."</td>\n";
       }
       $x = $f->version;
       if ( $this->filter['name'] != "" ) {
         $x = eregi_replace("(". $this->filter['name'] .")","<span class=\"found\">\\1</span>",$x);
       }
       echo " <td align=\"right\">". $x ."&nbsp;</td>\n";

       $x = $f->filename;
       if ( $this->filter['name'] != "" ) {
         $x = eregi_replace("(". $this->filter['name'] .")","<span class=\"found\">\\1</span>",$x);
       }
       echo " <td>". $x ."</td>\n";
       if ( $f->ref != -1 ) {
         echo " <td align=\"right\">". $f->getRefLink() ."</td>\n";
       } else {
         echo " <td align=\"right\">". $lang['HistoryDeleted'] ." (". $f->link_id .")</td>\n";
       }
       echo " <td align=\"right\">". $f->filesize ."</td>\n";
       echo " <td align=\"right\">". $f->creation->getDateTime() ."&nbsp;</td>\n";

       echo $this->OverviewRowEnd($line++);
       $a++;
     }
     echo "</tbody>\n";

     echo "<tfoot>\n";
     echo $this->list_navigation($this->link1,6,$this->start,$a,$n);
     echo "</tfoot>\n";
     echo $this->OverviewTableEnd();
     $this->result->free();
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['FileOverview'];
     $this->link1 = "file/file_overview.php";

     $this->q = "SELECT * FROM ". $this->dbconn->prefix ."files";
     $pre = " WHERE " ;

     if ( isset($_GET['link_id']) ) {
       $this->q .= $pre . " link_id = ". $_GET['link_id'];
       $pre = " AND " ;
       $this->link1 = addUrlParameter($this->link1,"link_id=". $_GET['link_id']);
     }
     if ( isset($_GET['author']) ) {
       $this->q .= $pre . " author = ". $_GET['author'];
       $pre = " AND " ;
       $this->link1 = addUrlParameter($this->link1,"author=". $_GET['author']);
     }
     if ( isset($_GET['creator']) ) {
       $this->q .= $pre . " creator = ". $_GET['creator'];
       $pre = " AND " ;
       $this->link1 = addUrlParameter($this->link1,"creator=". $_GET['creator']);
     }
     if ( isset($_GET['type']) ) {
       $this->q .= $pre . $this->dbconn->Like("type",$_GET['type']);
       $pre = " AND " ;
       $this->link1 = addUrlParameter($this->link1,"type=". UrlEncode($_GET['type']));
     }
     if ( isset($_GET['name']) && ($_GET['name'] != "") ) {
       $this->q .= $pre . "(";
       $this->q .= $this->dbconn->Like("name",$_GET['name']);
       $this->q .= " OR ". $this->dbconn->Like("filename",$_GET['name']);
       $this->q .= " OR ". $this->dbconn->Like("version",$_GET['name']);
       # $this->q .= " OR ". $this->dbconn->Like("logtxt",$name);
       $this->q .= ")";
       $pre = " AND " ;
       $this->link1 = addUrlParameter($this->link1,"name=". UrlEncode($_GET['name']));
       $this->filter['name'] = $_GET['name'];
     } else {
       $this->filter['name'] = "";
     }

     # Start Date for search
     $from = new DateTime(0);
     if ( isset($_GET['fd']) ) {
       $from->setDateTime($_GET['fd']);
     } else {
       $from->setDateTimeF("f");
       # remember this
       $_SESSION['filesearchfrom'] = $from->getYYYYMMDD();
     }
     if ( $from->notime != 1 ) {
       $this->q .= $pre ."(creation >= ". $this->dbconn->Date($from) .")";
       $pre = " AND ";

       $this->link1 = addUrlParameter($this->link1,"fd=".$from->getYYYYMMDD());
       $this->filter['from'] = $from;
     }
     # End Date for search
     $to = new DateTime(0);
     if ( isset($_GET['td']) ) {
       $to->setDateTime($_GET['td']);
     } else {
       $to->setDateTimeF("t");
       # remember this
       $_SESSION['filesearchto'] = $to->getYYYYMMDD();
     }
     if ( $to->notime != 1 ) {
       $this->q .= $pre ."(creation <= ". $this->dbconn->Date($to) .")";
       $pre = " AND ";

       $this->link1 = addUrlParameter($this->link1,"td=".$to->getYYYYMMDD());
       $this->filter['to'] = $to;
     }

     check_dbacl( $this->q, $this->user->id);

     # sorting
     $xxx = "";
     $this->link2 = $this->link1;
     order_parse($this->q,$this->link1,$xxx,$xxx,"name");
     $this->result = $this->dbconn->Exec($this->q);
     if ( 0 == $this->result->numrows()) {
       $this->redirect = "file_select.php?msg=". UrlEncode($lang['Err0048']);
       $this->result->free();
     }

     # menu
     $m = tutos_file::getSelectLink($this->user);
	 $m[category][] = "obj";
     $this->addmenu($m);
   }
 }

 $l = new file_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: file_overview.php,v 1.6.2.1 2003/07/14 17:49:52 gokohnert Exp $
    $Author: gokohnert $
-->
