#Boa:Dialog:StreamInfo
#TunaPie (c)2005-2007 James Stone. Released under the GNU GPL.
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#
#Written using Boa-Constructor.
#http://boa-constructor.sourceforge.net/
#
#Version 0.1.2 02/05/07


import wx
import wx.lib.stattext
import tuner

def create(parent):
    return StreamInfo(parent)

[wxID_STREAMINFO, wxID_STREAMINFOINFOBOX, wxID_STREAMINFOINFOBUTTON, 
 wxID_STREAMINFOOKBUTTON, wxID_STREAMINFOURLLABEL, 
] = [wx.NewId() for _init_ctrls in range(5)]

class StreamInfo(wx.Dialog):
    def _init_ctrls(self, prnt):
        # generated method, don't edit
        wx.Dialog.__init__(self, id=wxID_STREAMINFO, name=u'StreamInfo',
              parent=prnt, pos=wx.Point(295, 232), size=wx.Size(438, 259),
              style=wx.DEFAULT_DIALOG_STYLE, title=u'Stream Info')
        self.SetClientSize(wx.Size(438, 259))
        self.SetThemeEnabled(True)
        self.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)

        self.urllabel = wx.lib.stattext.GenStaticText(ID=wxID_STREAMINFOURLLABEL,
              label=u'Info:', name=u'urllabel', parent=self, pos=wx.Point(16,
              16), size=wx.Size(21, 17), style=0)
        self.urllabel.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Helvetica'))
        self.urllabel.SetThemeEnabled(True)

        self.okbutton = wx.Button(id=wxID_STREAMINFOOKBUTTON, label=u'OK',
              name=u'okbutton', parent=self, pos=wx.Point(280, 216),
              size=wx.Size(85, 30), style=0)
        self.okbutton.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Helvetica'))
        self.okbutton.SetThemeEnabled(True)
        self.okbutton.Bind(wx.EVT_BUTTON, self.OnOkbuttonButton,
              id=wxID_STREAMINFOOKBUTTON)

        self.infobox = wx.ListBox(choices=[], id=wxID_STREAMINFOINFOBOX,
              name=u'infobox', parent=self, pos=wx.Point(56, 16),
              size=wx.Size(352, 184), style=0)
        self.infobox.SetThemeEnabled(True)

        self.infobutton = wx.Button(id=wxID_STREAMINFOINFOBUTTON, label=u'Info',
              name=u'infobutton', parent=self, pos=wx.Point(100, 216),
              size=wx.Size(85, 30), style=0)
        self.infobutton.Show(True)
        self.infobutton.Bind(wx.EVT_BUTTON, self.OnInfobuttonButton,
              id=wxID_STREAMINFOINFOBUTTON)

    def __init__(self, parent):
        self._init_ctrls(parent)

    def setfontsize(self, newsize):
        size=int(newsize)
        self.urllabel.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.okbutton.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
    
    def OnOkbuttonButton(self, event):
        self.Close()
        
    def FillInfo (self, info, browser=""):
        okurl=0
        self.browser=browser
        for item in info:
            itemstrip=item.rstrip('\n')
            self.infobox.Append(itemstrip)
            print(itemstrip)
            if itemstrip.find("File")==0:
                if not(okurl):
                    url=itemstrip[itemstrip.find("=")+1:]
                    beginurl=url.find("//")+3
                    endurl=url[beginurl:].find("/")
                    if endurl==-1:
                        okurl=1
                        self.url=url
                    else:
                        self.url=url[:beginurl+endurl]

    def infobuttonhide(self):
        self.infobutton.Hide()

    def OnInfobuttonButton(self, event):
        try: tuner.showpage(self.browser,self.url)
        except AttributeError: 
            pass
