//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef QtProgress_TULIP
#define QtProgress_TULIP
#include <string>
#include <tulip/PluginProgress.h>
#include "QtProgressData.h"

class GlGraphWidget;

class QtProgress:public QtProgressData, public tlp::PluginProgress {

  Q_OBJECT

public:
  QtProgress(QWidget* parent,std::string text, GlGraphWidget * =0);
  virtual ~QtProgress();
  void progress_handler(int i,int j);
  void setComment(std::string msg);
  void showPreview(bool);
public slots:
  void stopCompute();
  void cancelCompute();
  void changePreview(bool);

public:
  bool firstCall;
  std::string label;
  QWidget* parent;
  GlGraphWidget *glGraphWidget;
};

#endif
