//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef MOUSEADDEDGE_H
#define MOUSEADDEDGE_H
#include <vector>
#include <tulip/Graph.h>
#include <tulip/Coord.h>
#include <tulip/GWInteractor.h>

namespace tlp {

/** \addtogroup Mouse_interactor */ 
/*@{*/
class TLP_QT_SCOPE MouseEdgeBuilder:public GWInteractor
{
 private:
  node source;
  bool started;
  Coord startPos,curPos;
  std::vector<Coord> bends;

 public:
  MouseEdgeBuilder();
  ~MouseEdgeBuilder(){}
  bool draw(GlGraphWidget *);
  bool eventFilter(QObject *, QEvent *);
  GWInteractor *clone() { return new MouseEdgeBuilder(); }
};
/*@}*/

}
#endif
