//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cassert>
#include <iostream>
#include "tulip/ObservableGlGraph.h"

using namespace std;
using namespace tlp;

void ObservableGlGraph::notifyMoveCamera(GlGraph *glGraph) {
  set<GlGraphObserver *> copy(observers); //Used to preserve iteratros
  for (set<GlGraphObserver *>::iterator itlObs=copy.begin();itlObs!=copy.end();++itlObs)
    (*itlObs)->moveCamera(glGraph);
}

void ObservableGlGraph::notifyMoveObject(GlGraph *glGraph) {
  set<GlGraphObserver *> copy(observers); //Used to preserve iteratros
  for (set<GlGraphObserver *>::iterator itlObs=copy.begin();itlObs!=copy.end();++itlObs)
    (*itlObs)->moveObject(glGraph);
}

void ObservableGlGraph::notifyDraw(GlGraph *glGraph) {
  set<GlGraphObserver *> copy(observers); //Used to preserve iteratros
  for (set<GlGraphObserver *>::iterator itlObs=copy.begin();itlObs!=copy.end();++itlObs)
    (*itlObs)->draw(glGraph);
}

void ObservableGlGraph::notifyDestroy(GlGraph *glGraph) {
  set<GlGraphObserver *> copy(observers); //Used to preserve iteratros
  for (set<GlGraphObserver *>::iterator itlObs=copy.begin();itlObs!=copy.end();++itlObs)
    (*itlObs)->destroy(glGraph);
}
