//-*-c++-*-
#ifndef TLPOVERVIEW_H
#define TLPOVERVIEW_H

#include "OverviewData.h"
#include <tulip/ObservableGlGraph.h>
#include <tulip/GlAugmentedDisplay.h>
#include <qcolor.h>
#include <string>
#include <qstring.h>



class GlGraph;
class QEvent;

struct RectPosition : public tlp::GlAugmentedDisplay 
{
  void draw(GlGraph *);
  RectPosition(GlGraphWidget *, GlGraph *);
  GlGraph *observedView;
private :
  GlGraphWidget *view;
};

class Overview : public OverviewData, public GlGraphObserver { 
  Q_OBJECT
  
public:
  Overview(QWidget* parent = 0, const char* name = 0, bool modal = FALSE, Qt::WFlags fl = 0 );
  ~Overview();
  void draw(GlGraph *);
  bool eventFilter(QObject *, QEvent *);

public slots:
  void updateView();
  void setObservedView(GlGraph *);
  void syncFromView();
  void backColor();
  void extendedView(bool);
  
private:
  void destroy(GlGraph *);
  GlGraph *observedView;
  bool synchronizing;
  RectPosition *glDraw;
};

#endif // VIEW3DSETUP_H
