//-*-c++-*-
#ifndef TULIP_SELECTIONPROXY_H
#define TULIP_SELECTIONPROXY_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "PropertyProxy.h"
#include "TemplateFactory.h"
#include "Selection.h"

class PropertyContext;
/** \addtogroup properties */ 
/*@{*/
class TLP_SCOPE SelectionProxy:public PropertyProxy<BooleanType,BooleanType, Selection> { 
  friend class Selection;

public :
  SelectionProxy (SuperGraph *);
  ~SelectionProxy();
  PProxy* clonePrototype(SuperGraph *, std::string );
  void copy( const node, const node, PProxy * );
  void copy( const edge, const edge, PProxy * );
  void reverse();
  ///reverse all the direction of edges of the visible graph which are true in this Selection Proxy
  void reverseEdgeDirection();
  Iterator<node> *getNodesEqualTo(const bool val, SuperGraph * = 0);
  Iterator<edge> *getEdgesEqualTo(const bool val, SuperGraph * = 0);
protected:
  void reset_handler();
};
/*@}*/
#endif
