//-*-c++-*-
/*
 Author: Delorme Maxime
 Email : Maxime.Delorme@gmail.com

 Last modification : 08/07/2005 (fr) 

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#ifndef _GLAD_GRID_H_
#define _GLAD_GRID_H_

#include "GlAugmentedDisplay.h"
//#include "GlADLine.h"

#include <vector>
#include <tulip/Coord.h>
#include <tulip/Color.h>
#include <tulip/Size.h>

namespace tlp {
/** \brief General class used to render grids as augmented displays.
 * 
 * This class is a generic class to render grids as augmented displays.
 * It does not uses the basic parameters of the GlAugmentedDisplay(position and color).
 */
class TLP_GL_SCOPE GlADGrid : public GlAugmentedDisplay {
 protected:
  
  //  std::vector<GlADLine*> XLines; /**< Vector storing every line aligned with the X axis */
  //  std::vector<GlADLine*> YLines; /**< Vector storing every line aligned with the Y axis */
  //  std::vector<GlADLine*> ZLines; /**< Vector storing every line aligned with the Z axis */

  //  int nXSteps; /**< The number of X axis aligned lines in a row */
  //  int nYSteps; /**< The number of Y axis aligned lines in a row */
  //  int nZSteps; /**< The number of Z axis aligned lines in a row */

  //  int nXLines; /**< The number of X axis aligned lines*/
  //  int nYLines; /**< The number of Y axis aligned lines*/
  //  int nZLines; /**< The number of Z axis aligned lines*/

  bool displayDim[3]; /**< Which dimensions should be displayed ? Note that only one dimension at most should be disabled*/
  bool hollowGrid; /**< Should the grid be hollowed ?*/

  Coord frontTopLeft; /**< Front top left point of the grid, the "minimum" */
  Coord backBottomRight; /**< Back bottom right point of the grid, the "maximum" */



  Color color; /**< The color of the grid */
  Size cell; /**< The size of a cell of the grid */

  /**
   * Default constructor
   *
   * \attention It's usage is forbidden, so that's why it has been put in protected members.
   */
  GlADGrid();

  /**
   * Function reseting the content of the vectors XLines, YLines and ZLines.
   */
  //  void resetVectors();

  /**
   * Function computing the lines of the grid.
   */
  //  void computeGrid();

 public:

  /**
   * Constructor
   *
   * \param frontTopLeft The minimum of the bounding box of the grid.
   * \param backBottomRight The maximum of the bounding box of the grid.
   * \param cell The size of a single cell of the grid.
   * \param color The color of the lines of the grid.
   * \param displays The dimensions of the grid to display.
   * \param hollowGrid Indicates if the grid chould be hollowed.
   */
  GlADGrid(const Coord& frontTopLeft, const Coord& backBottomRight, const Size& cell, const Color& color, bool displays[3], bool hollowGrid);

  /**
   * Destructor.
   */
  virtual ~GlADGrid();

  /**
   * Virtual function used to draw the grid.
   */
  virtual void draw(GlGraph* graph);

  /**
   * Virtual function used to trigger when changing the rendering options.
   */
  virtual void changeRenderOptions();

  /**
   * Accessor in reading to the holloGrid parameter.
   */
  bool getHollowGrid() const;

  /**
   * Accessor in reading to the dimensions to display.
   */
  void getDisplayDim(bool displayDim[3]) const;

  /**
   * Accessor in writing to the hollowGrid parameter.
   */
  void setHollowGrid(bool hollowGrid);

  /**
   * Accessor in writing to the dimensions to display.
   */
  void setDisplayDim(bool displayDim[3]);
};

}
#endif
