#ifndef GLAD_COMPOSITE_H
#define GLAD_COMPOSITE_H

#include "GlAugmentedDisplay.h"
#include <map>
#include <string>

#if (__GNUC__ < 3)
#include <hash_map>
#else
#include <ext/hash_map>
#endif

namespace tlp {
class TLP_GL_SCOPE GlADComposite : public GlAugmentedDisplay {

 private:
  /**
   * Function to give picking indexes to augmented displayes
   * \param glGraph the graph which contains these augmented displays.
   */
  void makeAugmentedDislplaySelect(GlGraph *glGraph);

 protected:
  stdext::hash_map<string, GlAugmentedDisplay*> elements;

 public:
  GlADComposite();
  ~GlADComposite();

  void reset(bool deleteElems);

  void addGlAugmentedDisplay(GlAugmentedDisplay *augmentedDisplay, const string & key);

  void deleteGlAugmentedDisplay(const std::string & key);
  void deleteGlAugmentedDisplay(GlAugmentedDisplay *augmentedDisplay);

  GlAugmentedDisplay* findGlAugmentedDisplay(const string & key);

  void draw(GlGraph *graph);

  /**
   * Determines which elements of the rendering context have been picked
   * by the mouse.  Returns true if items are picked.
   * \param x the x coordinate of the mouse click
   * \param y the y coordinate of the mouse click
   * \param width the width of the selection window
   * \param height the height of the selection window
   * \param pickedAugmentedDisplays the augmented displays which have been
   * picked
   * \param glGraph the glGraph which picking is executed on.
   */
  bool doSelect(const int x, const int y,
		const int width, const int height,
		vector <pair <string, GlAugmentedDisplay *> >
		&pickedAugmentedDisplays,
		GlGraph *glGraph);
};
}
#endif
