#include <qcolor.h>
#include <qslider.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qcolordialog.h>
#include <qframe.h>
#include <tulip/GlGraph.h>
#include <tulip/GlGraphWidget.h>

#include "Overview.h"

using namespace std;
Overview::Overview(QWidget* parent,  const char* name, bool modal, WFlags fl )
  : OverviewData( parent, name, modal ) {
  observedView=0;
  glDraw=0;
  extView->hide();
}

Overview::~Overview() {}

void Overview::draw(GlGraph *glG) {
  //  cerr << __PRETTY_FUNCTION__ << endl;
  view->getGlGraph()->setSceneTranslation(glG->getSceneTranslation());
  view->getGlGraph()->setSceneRotation(glG->getSceneRotation());
  Camera cam = glG->getCamera();
  cam.zoomFactor = 0.5;
  cam.eyes[0]=cam.eyes[1]=cam.center[0]=cam.center[1]=cam.center[2]=0;
  cam.up.set(0,1,0);
  view->getGlGraph()->setCamera(cam);
  view->updateGL();
}

void Overview::setObservedView(GlGraph *glV){
  //  cerr << __PRETTY_FUNCTION__ << endl << flush;
  if (observedView!=0)
    observedView->removeObserver(this);
  observedView=glV;
  if (glDraw==0) {
    glDraw = new RectPosition(view,observedView);
    view->setExternal(glDraw);
  }
  glDraw->observedView=observedView;
  view->setSuperGraph(glV->getSuperGraph());
  syncFromView();
  observedView->addObserver(this);
}

void Overview::backColor() {
  QColor tmp=QColorDialog::getColor(background->paletteBackgroundColor(), this, tr("Choose background color") ) ;
  if (tmp.isValid()) {
    background->setPaletteBackgroundColor(tmp);
    updateView();
  }
}

void Overview::extendedView(bool b) {
  if (!b)
    extView->hide();
  else
    extView->show();
}

void Overview::syncFromView() {
  if (observedView!=0) {
    synchronizing=true;
    arrows->setChecked( observedView->isViewArrow());
    edges->setChecked( observedView->isDisplayEdges());
    labels->setChecked( observedView->isViewLabel());
    interpolation->setChecked( observedView->isEdgeColorInterpolate());
    view->getGlGraph()->setEdgeColorInterpolate( observedView->isEdgeColorInterpolate() );
    strahler->setChecked( observedView->isViewStrahler());
    orthogonal->setChecked( observedView->isViewOrtho());
    view->getGlGraph()->setViewOrtho( observedView->isViewOrtho() );
    fan->setChecked( observedView->isViewKey());
    edge3D->setChecked( observedView->isEdged3D());
    Color tmp=observedView->getBackgroundColor();
    background->setPaletteBackgroundColor(QColor(tmp[0],tmp[1],tmp[2]));
    fonts->setCurrentItem(observedView->fontsType());
    density->setValue(observedView->getLabelsBorder());
    synchronizing=false;
  }
}

void Overview::updateView() {
  if (observedView!=0 && !synchronizing) {
    observedView->setViewArrow(arrows->isChecked());
    observedView->setDisplayEdges(edges->isChecked());
    observedView->setViewLabel(labels->isChecked());
    observedView->setEdgeColorInterpolate(interpolation->isChecked());
    view->getGlGraph()->setEdgeColorInterpolate( observedView->isEdgeColorInterpolate() );
    observedView->setViewStrahler(strahler->isChecked());
    observedView->setViewOrtho(orthogonal->isChecked());
    view->getGlGraph()->setViewOrtho(orthogonal->isChecked());
    observedView->setViewKey(fan->isChecked());
    observedView->setEdge3D(edge3D->isChecked());
    observedView->setFontsType(fonts->currentItem());
    QColor tmp = background->paletteBackgroundColor();
    observedView->setBackgroundColor(Color(tmp.red(),tmp.green(),tmp.blue()));
    observedView->setLabelsBorder(density->value());
    observedView->draw();
  }
}

void RectPosition::draw(GlGraph *target) {
  double x[4],xv[4];
  double y[4],yv[4];
  double z[4],zv[4];
  GLint *vp;
  int X,Y,W,H;
  vp = new GLint[4];  
  observedView->screenTo3DWorld(x[0],y[0],z[0]);
  observedView->getWinParameters(&X,&Y,&W,&H,&vp);
  delete [] vp;
  for (int i=0;i<4;++i)
    z[i]=0;
  x[0]=X; y[0]=Y;
  x[1]=X+W; y[1]=Y;
  x[2]=X+W; y[2]=Y+H;
  x[3]=X; y[3]=Y+H;
  for (int i=0;i<4;++i)
    observedView->screenTo3DWorld(x[i],y[i],z[i]);
  
  view->makeCurrent();
  vp = new GLint[4];  
  view->getGlGraph()->getWinParameters(&X,&Y,&W,&H,&vp);
  delete [] vp;
  for (int i=0;i<4;++i)
    zv[i]=0;
  xv[0]=X; yv[0]=Y;
  xv[1]=X+W; yv[1]=Y;
  xv[2]=X+W; yv[2]=Y+H;
  xv[3]=X; yv[3]=Y+H;
  for (int i=0;i<4;++i)
    view->getGlGraph()->screenTo3DWorld(xv[i],yv[i],zv[i]);

  glDisable(GL_LIGHTING);
  glDisable(GL_CULL_FACE);
  glDisable(GL_DEPTH_TEST);
  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA,GL_SRC_COLOR);
  float col[4]={0.8,0.8,0.8,0.2};
  glColor4fv(col);
  glBegin(GL_QUADS);
  for (int i=0;i<4;++i)
    glVertex3d(x[i],y[i],z[i]);
  glEnd();
  glDisable(GL_BLEND);
  glColor3ub(0,0,0);
  glLineWidth(1);
  glBegin(GL_LINE_LOOP);
  for (int i=0;i<4;++i)
    glVertex3d(x[i],y[i],z[i]);
  glEnd();
  glLineWidth(1);
 
  glEnable(GL_CULL_FACE);
  glLineStipple(2, 0xAAAA);
  glEnable(GL_LINE_STIPPLE);

  glBegin(GL_LINES);
  for (int i=0;i<4;++i) {
    glVertex3d(xv[i],yv[i],zv[i]);
    glVertex3d(x[i],y[i],z[i]);
  }
  glEnd();
  glDisable(GL_LINE_STIPPLE); 
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_LIGHTING);
  glDisable(GL_BLEND);
}

RectPosition::RectPosition(GlGraphWidget *view,GlGraph *observedView) : 
  observedView(observedView), view(view) {
}
