/**
 Author: David Auber
 Email : auber@labri.fr
 Last modification : 20/08/2001
 This program is free software; you can redistribute it and/or modify  *
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#include <assert.h>
#include "InducedSubGraphSelection.h"
#include <tulip/SelectionProxy.h>
#include <tulip/MethodFactory.h>

SELECTIONPLUGIN(InducedSubGraphSelection,"Induced sub-graph","David Auber","08/08/2001","Alpha","0","1");



namespace
{

	const char * paramHelp[] =
	{
		// selectedNodes
		HTML_HELP_OPEN() \
		HTML_HELP_DEF( "type", "SelectionProxy" ) \
		HTML_HELP_BODY() \
		"This selection defines the originally set of nodes used to extend the current selection to the induced sub-graph." \
		HTML_HELP_CLOSE(),
	};

}



InducedSubGraphSelection::InducedSubGraphSelection(const PropertyContext &context):Selection(context) {
  addParameter<SelectionProxy *>("selectedNodes",paramHelp[0],"viewSelection");
}

InducedSubGraphSelection::~InducedSubGraphSelection() {}

bool InducedSubGraphSelection::run() {

  selectionProxy->setAllNodeValue(false);
  SelectionProxy *entrySelection=0;
  if (dataSet!=0) dataSet->get("selectedNodes",entrySelection);  
  if (entrySelection==0) entrySelection=superGraph->getProperty<SelectionProxy>("viewSelection");
  
  Iterator<node> *itN=superGraph->getNodes();
  for (;itN->hasNext();) {
    node itn=itN->next();
    selectionProxy->setNodeValue(itn,entrySelection->getNodeValue(itn));
  }delete itN;

  Iterator<edge> *itE=superGraph->getEdges();
  for (;itE->hasNext();) {
    edge ite=itE->next();
    if (entrySelection->getNodeValue(superGraph->source(ite)) 
	&& entrySelection->getNodeValue(superGraph->target(ite)))
      selectionProxy->setEdgeValue(ite,true);
  }delete itE;

  return true;
}
