//-*-c++-*-
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cmath>

#include "tulip/Color.h"

static void RGBtoHSV(unsigned char r, unsigned char g, unsigned char b, int &h, int &s, int &v);
static void HSVtoRGB(int h, int s, int v, unsigned char &r, unsigned char &g, unsigned char &b);


long Color::getTrueColor()
{
  long ret=0;long tmp;
  int RR=array[0],BB=array[1],GG=array[2];
  tmp=RR << 16;
  ret=tmp;tmp=GG << 8;
  ret+=tmp;ret+=BB;
  return ret;
}

// HSV accessors
#define HSVGet(P)                               \
int Color::get##P() const {                     \
  int H,S,V;                                    \
  RGBtoHSV(array[0],array[1],array[2],H,S,V);   \
  return P;                                     \
}

HSVGet(H);
HSVGet(S);
HSVGet(V);
#undef HSVGet

#define HSVSet(P)                               \
void Color::set##P(int val) {                   \
  int H,S,V;                                    \
  RGBtoHSV(array[0],array[1],array[2],H,S,V);   \
  P = val;                                      \
  HSVtoRGB(H,S,V,array[0],array[1],array[2]);   \
}

HSVSet(H);
HSVSet(S);
HSVSet(V);
#undef HSVSet

//// static RGB<->HSV conversion functions
void RGBtoHSV(unsigned char r, unsigned char g, unsigned char b, int &h, int &s, int &v) {
  int min, max, delta;
  // "<?" and ">?" are GNU G++ extensions; may not work with other compiler
  min = r <? g <? b;
  max = r >? g >? b;
  v = max;				// v

  delta = max - min;

  if((max != 0) && (delta != 0))
    s = 255 * delta / max;		// s
  else {
    // r=g=b = 0		// s = 0, v is undefined
    s = 0;
    h = -1;
    return;
  }

  if(r == max)
    h = (int) (60 * (float)(g - b) / (float)delta);		// between yellow & magenta
  else if(g == max)
    h = (int) (60 * (2.0f + (float)(b - r) / (float)delta));	// between cyan & yellow
  else
    h = (int) (60 * (4.0f + (float)(r - g) / (float)delta));	// between magenta & cyan

  if(h < 0)
    h += 360;
}

void HSVtoRGB(int h, int s, int v, unsigned char &r, unsigned char &g, unsigned char &b) {
  int i;
  int p, q, t;
  float f, sf = s/255.0;

  if (v<0) v = 0;
  else if (v>255) v = 255;

  if (s<0) s = 0;
  else if (s>255) s = 255;

//   h %= 360;
//   if (h<0) h+=360;
  
  if(s == 0) {
    // achromatic (grey)
    r = g = b = v;
    return;
  }

  i = h/60;			// sector 0 to 5
  f = (h/60.0f - i);			// factorial part of h
  p = (int) (v * (1 - sf));
  q = (int) (v * (1 - sf * f));
  t = (int) (v * (1 - sf * (1 - f)));

  switch(i) {
  case 0:
    r = v;
    g = t;
    b = p;
    break;
  case 1:
    r = q;
    g = v;
    b = p;
    break;
  case 2:
    r = p;
    g = v;
    b = t;
    break;
  case 3:
    r = p;
    g = q;
    b = v;
    break;
  case 4:
    r = t;
    g = p;
    b = v;
    break;
  default:		// case 5:
    r = v;
    g = p;
    b = q;
    break;
  }
}
