#include "tulip/SuperGraph.h"
#include "tulip/Biconnex.h"
#include "tulip/MutableContainer.h"

using namespace std;
//=================================================================
BiconnexTest * BiconnexTest::instance=0;
//=================================================================
bool biconnexTest(SuperGraph *graph, node v, 
		  MutableContainer<bool> &mark,
		  MutableContainer<unsigned int> &low,
		  MutableContainer<unsigned int> &dfsNumber,
		  MutableContainer<node> &father,
		  unsigned int &count) {
  mark.set(v.id,true);
  dfsNumber.set(v.id,count);
  low.set(v.id,count);
  ++count;
  Iterator<node> *it=graph->getInOutNodes(v);
  while (it->hasNext()) {
    node w=it->next();
    if (!mark.get(w.id)) {
      father.set(w.id,v);
      if (!biconnexTest(graph,w,mark,low,dfsNumber,father,count)) {
	delete it;
	return false;
      }
      if (v.id!=1) {
	if (low.get(w.id)>=dfsNumber.get(v.id)) {
	  delete it;
	  //cerr <<"Node :" << v.id << " is a separator" << endl;
	  return false;
	}
	else
	  low.set(v.id, low.get(v.id) <? low.get(w.id));
      }
    }
    else
      if (father.get(v.id)!=w) {
	low.set(v.id, low.get(v.id) <? dfsNumber.get(w.id));
      }
  } delete it;
  return true;
}
//=================================================================
BiconnexTest::BiconnexTest(){
}
//=================================================================
bool BiconnexTest::isBiconnex(SuperGraph *graph) {
  if (instance==0)
    instance=new BiconnexTest();
  return instance->compute(graph);
}
//=================================================================
bool BiconnexTest::compute(SuperGraph *graph) { 
  if (resultsBuffer.find((unsigned int)graph)!=resultsBuffer.end()) 
    return resultsBuffer[(unsigned int)graph];
  graph->addObserver(this);
  MutableContainer<bool> mark;
  mark.setAll(false);
  MutableContainer<unsigned int> low;
  MutableContainer<unsigned int> dfsNumber;
  MutableContainer<node> father;
  unsigned int count = 1;
  bool result = false;
  Iterator<node> *it=graph->getNodes();
  if (it->hasNext())
    result=(biconnexTest(graph,it->next(),mark,low,dfsNumber,father,count));
  delete it;
  if (count!=graph->numberOfNodes()+1) result=false; //connected test
  resultsBuffer[(unsigned int)graph]=result;
  return result;
}
//=================================================================
void BiconnexTest::addEdge(SuperGraph *graph,const edge) {
  if (resultsBuffer[(unsigned int)graph]) return;
  graph->removeObserver(this);
  resultsBuffer.erase((unsigned int)graph);
}
//=================================================================
void BiconnexTest::delEdge(SuperGraph *graph,const edge) {
  graph->removeObserver(this);
  resultsBuffer.erase((unsigned int)graph);
}
//=================================================================
void BiconnexTest::reverseEdge(SuperGraph *graph,const edge) {
}
//=================================================================
void BiconnexTest::addNode(SuperGraph *graph,const node) {
  resultsBuffer[(unsigned int)graph]=false;
}
//=================================================================
void BiconnexTest::delNode(SuperGraph *graph,const node) {
  graph->removeObserver(this);
  resultsBuffer.erase((unsigned int)graph);
}
//=================================================================
void BiconnexTest::destroy(SuperGraph *graph) {
  graph->removeObserver(this);
  resultsBuffer.erase((unsigned int)graph);
}
//=================================================================
