//-*-c++-*-
#ifndef TULIP_INTPROXY_H
#define TULIP_INTPROXY_H

#include "PropertyProxy.h"
#include "MethodFactory.h"
#include "TemplateFactory.h"

class Ggraph;
class PropertyContext;

/** \addtogroup properties */ 
/*@{*/
class IntProxy:public PropertyProxy<IntType,IntType>{ 

  friend class Int;

public :
  IntProxy (SuperGraph *);
  ~IntProxy();
  IntType::RealType  getNodeMin();
  IntType::RealType  getNodeMax();
  IntType::RealType  getEdgeMin();
  IntType::RealType  getEdgeMax();
  PProxy* clonePrototype(SuperGraph *, std::string );
  void copy( const node, const node, PProxy * );
  void copy( const edge, const edge, PProxy * );
  void reset_handler();
  void recompute_handler();
  void clone_handler(PropertyProxy<IntType,IntType> &);

private:
  int maxN,minN,maxE,minE;
  bool minMaxOk;
  void computeMinMax();
};
/*@}*/
#endif
