//-*-c++-*-
#ifndef Tulip_FANERROR_H
#define Tulip_FANERROR_H

#include <list>
#include <tulip/Coord.h>

using namespace std;

struct FanError {
  
  /**
     Build a new FanError Object
   */
  FanError(const Coord &center,double angleThreshold,double lengthThreshold);
  /**
     return :
     - 0 if the vertex was added successfully. 
     - 1 if we need to build a new blade.
     - 2 if we need to start a new fan.
  */
  unsigned int addVertex(Coord newVertex);
  /**
     Reset the fan error evaluation, but keep the center verter 
     of the fan. Use this method to avoid creation of objects.
   */
  void reset();
private:
  //Parameters
  Coord fanCenter;
  double angleThreshold,lengthThreshold;

  //Need to compute results
  double currentAngle;
  double lengthSum;
  list<double> lengthValues; //used in order to compute the standart deviation
  Coord lastVertex;
  //This variable can be removed if we use the size of lengthValue, lengthValue.size()
  unsigned int numberOfVertex;
};


#endif
