package games.strategy.engine.data.annotations;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.DefaultAttachment;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.UnitType;
import games.strategy.util.IntegerMap;

/**
 * Class with an invalidly named clear method
 */
public class InvalidClearExample extends DefaultAttachment {
  private static final long serialVersionUID = 113427104352979892L;

  protected InvalidClearExample(final String name, final Attachable attachable, final GameData gameData) {
    super(name, attachable, gameData);
  }

  private final IntegerMap<UnitType> m_givesMovement = new IntegerMap<UnitType>();

  @GameProperty(xmlProperty = true, gameProperty = true, adds = true)
  public void setGivesMovement(final String value) {}

  public void resetGivesMovement() {}

  public void clearMovement() // badly named, should cause test to fail
  {
    m_givesMovement.clear();
  }

  public IntegerMap<UnitType> getGivesMovement() {
    return m_givesMovement;
  }

  @Override
  public void validate(final GameData data) throws GameParseException {
    // TODO Auto-generated method stub
  }
}
