package games.strategy.engine.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;

import games.strategy.triplea.xml.LoadGameUtil;
import junit.framework.TestCase;

public class ChangeTripleATest extends TestCase {
  private GameData m_data;

  public ChangeTripleATest(final String name) {
    super(name);
  }

  @Override
  public void setUp() throws Exception {
    m_data = LoadGameUtil.loadGame("Big World : 1942", "big_world_1942_test.xml");
  }

  private Change serialize(final Change aChange) throws Exception {
    final ByteArrayOutputStream sink = new ByteArrayOutputStream();
    final ObjectOutputStream output = new GameObjectOutputStream(sink);
    output.writeObject(aChange);
    output.flush();
    // System.out.println("bytes:" + sink.toByteArray().length);
    final InputStream source = new ByteArrayInputStream(sink.toByteArray());
    final ObjectInputStream input =
        new GameObjectInputStream(new games.strategy.engine.framework.GameObjectStreamFactory(m_data), source);
    final Change newChange = (Change) input.readObject();
    input.close();
    output.close();
    return newChange;
  }

  public void testUnitsAddTerritory() {
    // make sure we know where we are starting
    final Territory can = m_data.getMap().getTerritory("Western Canada");
    assertEquals(can.getUnits().getUnitCount(), 2);
    // add some units
    final Change change =
        ChangeFactory.addUnits(can, m_data.getUnitTypeList().getUnitType("infantry").create(10, null));
    final ChangePerformer changePerformer = new ChangePerformer(m_data);
    changePerformer.perform(change);
    assertEquals(can.getUnits().getUnitCount(), 12);
    // invert the change
    changePerformer.perform(change.invert());
    assertEquals(can.getUnits().getUnitCount(), 2);
  }

  public void testUnitsRemoveTerritory() {
    // make sure we now where we are starting
    final Territory can = m_data.getMap().getTerritory("Western Canada");
    assertEquals(can.getUnits().getUnitCount(), 2);
    // remove some units
    final Collection<Unit> units = can.getUnits().getUnits(m_data.getUnitTypeList().getUnitType("infantry"), 1);
    final Change change = ChangeFactory.removeUnits(can, units);
    final ChangePerformer changePerformer = new ChangePerformer(m_data);
    changePerformer.perform(change);
    assertEquals(can.getUnits().getUnitCount(), 1);
    // invert the change
    changePerformer.perform(change.invert());
    assertEquals(can.getUnits().getUnitCount(), 2);
  }

  public void testSerializeUnitsRemoteTerritory() throws Exception {
    // make sure we now where we are starting
    final Territory can = m_data.getMap().getTerritory("Western Canada");
    assertEquals(can.getUnits().getUnitCount(), 2);
    // remove some units
    final Collection<Unit> units = can.getUnits().getUnits(m_data.getUnitTypeList().getUnitType("infantry"), 1);
    Change change = ChangeFactory.removeUnits(can, units);
    change = serialize(change);
    final ChangePerformer changePerformer = new ChangePerformer(m_data);
    changePerformer.perform(change);
    assertEquals(can.getUnits().getUnitCount(), 1);
    // invert the change
    changePerformer.perform(change.invert());
    assertEquals(can.getUnits().getUnitCount(), 2);
  }
}
