package games.strategy.triplea.ui;

import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.Properties;

import games.strategy.triplea.ResourceLoader;

/**
 * Returns a bunch of messages from politicstext.properties
 */
public class PoliticsText {
  // Filename
  private static final String PROPERTY_FILE = "politicstext.properties";
  private static PoliticsText s_pt = null;
  private static long s_timestamp = 0;
  private final Properties m_properties = new Properties();
  private final static String BUTTON = "BUTTON";
  private final static String DESCRIPTION = "DESCRIPTION";
  private final static String NOTIFICATION_SUCCESS = "NOTIFICATION_SUCCESS";
  private final static String OTHER_NOTIFICATION_SUCCESS = "OTHER_NOTIFICATION_SUCCESS";
  private final static String NOTIFICATION_FAILURE = "NOTIFICATION_FAILURE";
  private final static String OTHER_NOTIFICATION_FAILURE = "OTHER_NOTIFICATION_FAILURE";
  private static final String ACCEPT_QUESTION = "ACCEPT_QUESTION";

  protected PoliticsText() {
    final ResourceLoader loader = AbstractUIContext.getResourceLoader();
    final URL url = loader.getResource(PROPERTY_FILE);
    if (url == null) {
      // no propertyfile found
    } else {
      try {
        m_properties.load(url.openStream());
      } catch (final IOException e) {
        System.out.println("Error reading " + PROPERTY_FILE + " : " + e);
      }
    }
  }

  public static PoliticsText getInstance() {
    if (s_pt == null || Calendar.getInstance().getTimeInMillis() > s_timestamp + 10000) { // cache properties for 10 seconds
      s_pt = new PoliticsText();
      s_timestamp = Calendar.getInstance().getTimeInMillis();
    }
    return s_pt;
  }

  private String getString(final String value) {
    return m_properties.getProperty(value, "NO: " + value + " set.");
  }

  private String getMessage(final String politicsKey, final String messageKey) {
    return getString(politicsKey + "." + messageKey);
  }

  public String getButtonText(final String politicsKey) {
    return getMessage(politicsKey, BUTTON);
  }

  public String getDescription(final String politicsKey) {
    return getMessage(politicsKey, PoliticsText.DESCRIPTION);
  }

  public String getNotificationSucccess(final String politicsKey) {
    return getMessage(politicsKey, PoliticsText.NOTIFICATION_SUCCESS);
  }

  public String getNotificationSuccessOthers(final String politicsKey) {
    return getMessage(politicsKey, PoliticsText.OTHER_NOTIFICATION_SUCCESS);
  }

  public String getNotificationFailure(final String politicsKey) {
    return getMessage(politicsKey, PoliticsText.NOTIFICATION_FAILURE);
  }

  public String getNotificationFailureOthers(final String politicsKey) {
    return getMessage(politicsKey, PoliticsText.OTHER_NOTIFICATION_FAILURE);
  }

  public String getAcceptanceQuestion(final String politicsKey) {
    return getMessage(politicsKey, PoliticsText.ACCEPT_QUESTION);
  }
}
