


INCLUDE(PackageAddExecutableAndTest)
INCLUDE(PackageCopyFilesToBinaryDir)


FUNCTION(ADD_TEST_BATCH TestList)

   PARSE_ARGUMENTS(
     #prefix
     PARSE
     #lists
     "SOURCES;DEPLIBS;NUM_MPI_PROCS;DIRECTORY;KEYWORDS;COMM;ARGS;NAME;PASS_REGULAR_EXPRESSION;HOST;XHOST;FAIL_REGULAR_EXPRESSION;DATA_FILES;DATA_SOURCE_DIR"
     #options
     "STANDARD_PASS_OUTPUT"
     ${ARGN}
     )

  FOREACH(TestName ${${TestList}})


    SET(CALL_ARGS "")

    IF (PARSE_DEPLIBS)
       SET(CALL_ARGS ${CALL_ARGS} DEPLIBS ${PARSE_DEPLIBS}) 
    ENDIF()

    IF (PARSE_DIRECTORY)
       SET(CALL_ARGS ${CALL_ARGS} DIRECTORY ${PARSE_DIRECTORY}) 
    ENDIF()

    IF (PARSE_KEYWORDS)
      SET(CALL_ARGS ${CALL_ARGS} KEYWORDS ${PARSE_KEYWORDS}) 
    ENDIF()

    IF (PARSE_COMM)
      SET(CALL_ARGS ${CALL_ARGS} COMM ${PARSE_COMM}) 
    ENDIF()

    IF (PARSE_NUM_MPI_PROCS)
      SET(CALL_ARGS ${CALL_ARGS} NUM_MPI_PROCS ${PARSE_NUM_MPI_PROCS}) 
    ENDIF()

    IF (PARSE_ARGS)
      SET(CALL_ARGS ${CALL_ARGS} ARGS ${PARSE_ARGS}) 
    ENDIF()

    IF (PARSE_HOST)
      SET(CALL_ARGS ${CALL_ARGS} HOST ${PARSE_HOST}) 
    ENDIF()

    IF (PARSE_XHOST)
      SET(CALL_ARGS ${CALL_ARGS} XHOST ${PARSE_XHOST}) 
    ENDIF()

    IF (PARSE_PASS_REGULAR_EXPRESSION)
      SET(CALL_ARGS ${CALL_ARGS} PASS_REGULAR_EXPRESSION ${PARSE_PASS_REGULAR_EXPRESSION}) 
    ENDIF()

    IF (PARSE_FAIL_REGULAR_EXPRESSION)
      SET(CALL_ARGS ${CALL_ARGS} FAIL_REGULAR_EXPRESSION ${PARSE_FAIL_REGULAR_EXPRESSION}) 
    ENDIF()

    IF (PARSE_STANDARD_PASS_OUTPUT)
      SET(CALL_ARGS ${CALL_ARGS} STANDARD_PASS_OUTPUT)
    ENDIF()

  PACKAGE_ADD_EXECUTABLE_AND_TEST(
       ${TestName} 
       SOURCES ${TestName}.cpp
       ${CALL_ARGS}
   )

  SET(CALL_ARGS "")
  IF (PARSE_DATA_FILES)
     SET(CALL_ARGS ${CALL_ARGS} DEST_FILES ${PARSE_DATA_FILES}) 

    IF (PARSE_DATA_SOURCE_DIR)
       SET(CALL_ARGS ${CALL_ARGS} SOURCE_DIR ${PARSE_DATA_SOURCE_DIR}) 
    ENDIF()

    PACKAGE_COPY_FILES_TO_BINARY_DIR(${TestName}_CopyData
       ${CALL_ARGS}
     )
     # Removing for now: EXEDEPS ${TestName}
     # NOTE: You really don't need this as you can just type 'make' in the
     # build directory and the target will get built.
  ENDIF()


ENDFOREACH()

ENDFUNCTION()