#for KEY_NAME in $(openssl ecparam -list_curves | grep : | cut -f1 -d:); do echo ===$KEY_NAME=== ; openssl ecparam -name $KEY_NAME ;  openssl ecparam -name $KEY_NAME -param_enc explicit ; done
===secp112r1===
-----BEGIN EC PARAMETERS-----
BgUrgQQABg==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGLAgEBMBoGByqGSM49AQECDwDbfCq/YuNeZoB2vq0gizA3BA7bfCq/YuNeZoB2
vq0giAQOZZ74ugQ5Fu7eiRFwKyIDFQAA9QsCjk1pbmdodWFRdSkEcng/sQQdBAlI
cjmZWl7na1X5wvCYqJzlr4ckwKI+Dg/3dQACDwDbfCq/YuNedijfrGVhxQIBAQ==
-----END EC PARAMETERS-----
===secp112r2===
-----BEGIN EC PARAMETERS-----
BgUrgQQABw==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGKAgEBMBoGByqGSM49AQECDwDbfCq/YuNeZoB2vq0gizA3BA5hJ8JMBfOKCqr2
XA7wLAQOUd7xgV217XT8w0yF1wkDFQAAJ1ehEU1pbmdodWFRdVMWwF4L1AQdBEuj
CrXokrThZJ3QkoZDrc1G9YguN0fe826VbpcCDjbfCq/YuNdZfKEFINBLAgEE
-----END EC PARAMETERS-----
===secp128r1===
-----BEGIN EC PARAMETERS-----
BgUrgQQAHA==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGXAgEBMBwGByqGSM49AQECEQD////9////////////////MDsEEP////3/////
//////////wEEOh1ecEQefQ92CSZPCzuXtMDFQAADg1NaW5naHVhUXUMwDpEc9A2
eQQhBBYf91KLiZstDChgfKUsW4bPWsg5W6/rE8AtopLd7XqDAhEA/////gAAAAB1
ow0bkDihFQIBAQ==
-----END EC PARAMETERS-----
===secp128r2===
-----BEGIN EC PARAMETERS-----
BgUrgQQAHQ==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGWAgEBMBwGByqGSM49AQECEQD////9////////////////MDsEENYDGZjRs7v+
v1nMm7/5ruEEEF7u/KOA0CkZ3CxlWLttil0DFQAATWluZ2h1YVF1EtjwNDH85juI
9AQhBHtqpdheVymD5vsyp83rwUAntpFqiU067nEG/oBfw0tEAhA/////f////74A
JHIGE7WjAgEE
-----END EC PARAMETERS-----
===secp160k1===
-----BEGIN EC PARAMETERS-----
BgUrgQQACQ==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MHICAQEwIAYHKoZIzj0BAQIVAP////////////////////7//6xzMAYEAQAEAQcE
KQQ7TDgs43qhkqQBnnYwNvT13U1+u5OM+TUxj9zta8KChlMXM8PwPE/uAhUBAAAA
AAAAAAAAAbj6Ft+rmsoWtrMCAQE=
-----END EC PARAMETERS-----
===secp160r1===
-----BEGIN EC PARAMETERS-----
BgUrgQQACA==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGvAgEBMCAGByqGSM49AQECFQD/////////////////////f////zBDBBT/////
////////////////f////AQUHJe+/FS9eotlrPifgdTUrcVl+kUDFQAQU83kLBTW
luZ2h1YVF1M78/gzRQQpBEqWtWiO9XMoRmRpiWjDi7kTy/yCI6YoVTFolH1Z3MkS
BCNRN3rF+zICFQEAAAAAAAAAAAAB9Mj5J67TynUiVwIBAQ==
-----END EC PARAMETERS-----
===secp160r2===
-----BEGIN EC PARAMETERS-----
BgUrgQQAHg==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGvAgEBMCAGByqGSM49AQECFQD////////////////////+//+sczBDBBT/////
///////////////+//+scAQUtOE00/tZ64urVydJBGZNWvUDiLoDFQC5m5mwmbMj
4CcJpNaW5naHVhUXUQQpBFLcsDQpOhF+H0/xGzD3GZ0xRM5t/q/+8uMx8pbgcfoN
+Zgs/qfUPy4CFQEAAAAAAAAAAAAANR7nhqgY86GhawIBAQ==
-----END EC PARAMETERS-----
===secp192k1===
-----BEGIN EC PARAMETERS-----
BgUrgQQAHw==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGCAgEBMCQGByqGSM49AQECGQD//////////////////////////v//7jcwBgQB
AAQBAwQxBNtP8Q7AV+muJrB9AoC39DQdpdGx6uBsfZsvL22cViinhEFj0BW+hjRA
gqqI2V4vnQIZAP///////////////iby/BcPaUZqdN79jQIBAQ==
-----END EC PARAMETERS-----
===secp224k1===
-----BEGIN EC PARAMETERS-----
BgUrgQQAIA==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGSAgEBMCgGByqGSM49AQECHQD///////////////////////////////7//+Vt
MAYEAQAEAQUEOQShRVszTfCZ3zD8KKFppGfp5HB1qQ9+ZQ62t6Rcfgif7X+6NEKC
yvvW9+MZ98CwvVniykvbVW1hpQIdAQAAAAAAAAAAAAAAAAAB3OjS7GGEyvCpcXaf
sfcCAQE=
-----END EC PARAMETERS-----
===secp224r1===
-----BEGIN EC PARAMETERS-----
BgUrgQQAIQ==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIHfAgEBMCgGByqGSM49AQECHQD/////////////////////AAAAAAAAAAAAAAAB
MFMEHP////////////////////7///////////////4EHLQFCoUMBLOr9UEyVlBE
sLfXv9i6Jws5QyNV/7QDFQC9cTRHmdXH/NxFtZ+juauPapSLxQQ5BLcODL1rtL9/
MhOQuUoDwdNWwhEiNDKA1hFcHSG9N2OItfcj+0wi3+bNQ3WgWgdHZETVgZmFAH40
Ah0A//////////////////8WouC48D4T3SlFXFwqPQIBAQ==
-----END EC PARAMETERS-----
===secp256k1===
-----BEGIN EC PARAMETERS-----
BgUrgQQACg==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGiAgEBMCwGByqGSM49AQECIQD////////////////////////////////////+
///8LzAGBAEABAEHBEEEeb5mfvncu6xVoGKVzocLBwKb/NstzijZWfKBWxb4F5hI
Otp3JqPEZV2k+/wOEQio/Re0SKaFVBmcR9CP+xDUuAIhAP//////////////////
//66rtzmr0igO7/SXozQNkFBAgEB
-----END EC PARAMETERS-----
===secp384r1===
-----BEGIN EC PARAMETERS-----
BgUrgQQAIg==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIIBVwIBATA8BgcqhkjOPQEBAjEA////////////////////////////////////
//////7/////AAAAAAAAAAD/////MHsEMP//////////////////////////////
///////////+/////wAAAAAAAAAA/////AQwszEvp+I+5+SYjgVr4/gtGRgdnG7+
gUESAxQIj1ATh1rGVjmNii7RnSqFyO3T7CrvAxUAozWSaqMZonodAIlqZ3OkgnrN
rHMEYQSqh8oivosFN46xxx7zIK10bh07Younm5hZ90HgglQqOFUC8l2/VSlsOlRe
OHJ2Crc2F95KliYsb12emL+Sktwp+PQdvSiaFHzp2jETtfC4wApgsc4dfoGdekMd
fJDqDl8CMQD////////////////////////////////HY02B9Dct31gaDbJIsKd6
7OwZaszFKXMCAQE=
-----END EC PARAMETERS-----
===secp521r1===
-----BEGIN EC PARAMETERS-----
BgUrgQQAIw==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIIBwgIBATBNBgcqhkjOPQEBAkIB////////////////////////////////////
//////////////////////////////////////////////////8wgZ4EQgH/////
////////////////////////////////////////////////////////////////
/////////////////ARBUZU+uWGOHJofkpohoLaFQO6i2nJbmbMV87i0iZGO8Qnh
Vhk5Uex+k3sWUsC9O7G/BzVz34g9LDTx70Uf1GtQPwADFQDQnogAKRy4U5bMZxc5
MoSqoNpkugSBhQQAxoWOBrcEBOnNnj7LZiOVtEKcZIE5BT+1Ifgor2BrTT26oUte
d+/nWSj+HcEnov+o3jNIs8GFakKb+X5+McLlvWYBGDkpaniaO8AEXIpftCx9G9mY
9URJV5tEaBevvRcnPmYsl+5ymV70JkDFULkBP60HYTU8cIaicsJAiL6Udp/RZlAC
QgH///////////////////////////////////////////pRhoeDvy+Wa3/MAUj3
CaXQO7XJuImcR667b7cekThkCQIBAQ==
-----END EC PARAMETERS-----
===prime192v1===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMBAQ==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIHHAgEBMCQGByqGSM49AQECGQD////////////////////+//////////8wSwQY
/////////////////////v/////////8BBhkIQUZ5ZyA5w+n6atyJDBJ/rje7MFG
ubEDFQAwRa5vyEIvZO1XlSjTgSDq4SGW1QQxBBiNqA6wMJD2fL8g60OhiAD0/wr9
gv8QEgcZK5X/yNp4YxAR7WskzdVz+XehHnlIEQIZAP///////////////5ne+DYU
a8mxtNIoMQIBAQ==
-----END EC PARAMETERS-----
===prime192v2===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMBAg==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIHHAgEBMCQGByqGSM49AQECGQD////////////////////+//////////8wSwQY
/////////////////////v/////////8BBjMItbfuVxrJeScDWNkpOWYDDk6ohZo
2VMDFQAxqS7iAp/RDZAbET6ZBxDw0hrGtgQxBO6iuufhSXhC8t53ac/pyYnAcq1p
b0gDSmV00R1ptux6Zyu4Kgg98vKwhH3pcLLeFQIZAP///////////////l+xpyTc
gEGGSNjdMQIBAQ==
-----END EC PARAMETERS-----
===prime192v3===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMBAw==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIHHAgEBMCQGByqGSM49AQECGQD////////////////////+//////////8wSwQY
/////////////////////v/////////8BBgiEj3COVoFyqdCPa7MyUdgp9RiJWvV
aRYDFQDEaWhENd6zeMS2XKlZHipXYwWaLgQxBH0pd4EAxlodoXg3FliNziuLSu6O
Io8YljipDyJjczczS0nctmptyPmXisp2SKlDsAIZAP///////////////3pi0DHI
P0KU9kDsEwIBAQ==
-----END EC PARAMETERS-----
===prime239v1===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMBBA==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIHpAgEBMCkGByqGSM49AQECHn///////////////3///////4AAAAAAAH//////
/zBXBB5///////////////9///////+AAAAAAAB///////wEHmsBbDvc8YlB0NZU
khR1ynGp2y+yfR03eWGFwpQsCgMVAOQ7tGDwuAzAwLB1eY6UgGD4Mht9BD0ED/qW
PNyogWzMM7hkK+35BcPTWFc9Pyf7vTs8uaqvfevo5OkKXa5uQFTKUwugRlSzaBjO
Ims5/Mt7AvGuAh5///////////////9///+eXpqfXZBx+9FSJoiQnQsCAQE=
-----END EC PARAMETERS-----
===prime239v2===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMBBQ==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIHpAgEBMCkGByqGSM49AQECHn///////////////3///////4AAAAAAAH//////
/zBXBB5///////////////9///////+AAAAAAAB///////wEHmF/q2gyV2y7/tUN
mfAknD/uWLlLoAOMeuhMjIMvLAMVAOi0ARYECVMDyjuAmZgr4J/LmuYWBD0EOK8J
2YcncFEgySG7Xp4mKWo83PLzV1eg6v2HuDDnWwEl5NvqDscgbaD8AdmwgTKftVXe
bvRgI33/i+S6Ah5///////////////+AAADPp+hZQ3fUFMA4IbxYIGMCAQE=
-----END EC PARAMETERS-----
===prime239v3===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMBBg==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIHpAgEBMCkGByqGSM49AQECHn///////////////3///////4AAAAAAAH//////
/zBXBB5///////////////9///////+AAAAAAAB///////wEHiVXBfoqMGZUsfTL
A9anUKMMJQEC1JiHF9m6FattPgMVAH1zdBaP/jRxtgqFdoahlHXTv6L/BD0EZ2iu
jhi7ks/PAFyUmqLG2UhT0OZgu/hUsclQX+laFgfmiY85DAa8HVUrrSJvO2/P5Itu
gYSZrxjj7WzzAh5///////////////9///+XXetBs6YFfDxDIUZSZVECAQE=
-----END EC PARAMETERS-----
===prime256v1===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMBBw==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIH3AgEBMCwGByqGSM49AQECIQD/////AAAAAQAAAAAAAAAAAAAAAP//////////
/////zBbBCD/////AAAAAQAAAAAAAAAAAAAAAP///////////////AQgWsY12Ko6
k+ez671VdpiGvGUdBrDMU7D2O848PifSYEsDFQDEnTYIhucEk2pmeOETnSa3gZ9+
kARBBGsX0fLhLEJH+Lzm5WOkQPJ3A32BLeszoPShOUXYmMKWT+NC4v4af5uO5+tK
fA+eFivOM1drMV7Oy7ZAaDe/UfUCIQD/////AAAAAP//////////vOb6racXnoTz
ucrC/GMlUQIBAQ==
-----END EC PARAMETERS-----
===sect113r1===
-----BEGIN EC PARAMETERS-----
BgUrgQQABA==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGPAgEBMBwGByqGSM49AQIwEQIBcQYJKoZIzj0BAgMCAgEJMDcEDjCIJQym58f+
ZJzoWCD3BA7ovuTT4iYHRBiL4OnHIwMVABDnI6sU1pbmdodWFRdW/r+Py0mpBB8E
AJ1zYW819KsUB9c1YsEPAKUoMCd5WO6E0TFe0xiGAg8BAAAAAAAAANnM7Io55W8C
AQI=
-----END EC PARAMETERS-----
===sect113r2===
-----BEGIN EC PARAMETERS-----
BgUrgQQABQ==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGPAgEBMBwGByqGSM49AQIwEQIBcQYJKoZIzj0BAgMCAgEJMDcEDmiZGNvsfloN
1t/AqlXHBA6V6ansmyl71L824FkYTwMVABDA+xV2CGDe8e701pbmdodWFRddBB8E
AaV6ansmyl71L824FkeXALOtyU7R/mdMBuaVurodAg8BAAAAAAAAAQh4mySWr5MC
AQI=
-----END EC PARAMETERS-----
===sect131r1===
-----BEGIN EC PARAMETERS-----
BgUrgQQAFg==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGkAgEBMCUGByqGSM49AQIwGgICAIMGCSqGSM49AQIDAzAJAgECAgEDAgEIMD0E
EQehGwmna1YhREGP8/+MJXC4BBECF8BWEIhLY7nGxykWePnTQQMVAE1pbmdodWFR
dZhb06262iG0OpfiBCMEAIG6+R/fmDPED5wYE0Njg5kHjG5+o4wAH3PIE0sbTvnh
UAIRBAAAAAAAAAACMSOVOpRktU0CAQI=
-----END EC PARAMETERS-----
===sect131r2===
-----BEGIN EC PARAMETERS-----
BgUrgQQAFw==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGkAgEBMCUGByqGSM49AQIwGgICAIMGCSqGSM49AQIDAzAJAgECAgEDAgEIMD0E
EQPlqIkZ18r8v0FfB8IXZXOyBBEEuCZqRsVWV6xzTOOPAY8hkgMVAJhb06261NaW
5naHVhUXWiG0OpfjBCMEA1bc2PL5UDGtZS0jlRuzZqgGSPBthnlApTZtniZd6esk
DwIRBAAAAAAAAAABaVSiMwSbqY8CAQI=
-----END EC PARAMETERS-----
===sect163k1===
-----BEGIN EC PARAMETERS-----
BgUrgQQAAQ==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MHkCAQEwJQYHKoZIzj0BAjAaAgIAowYJKoZIzj0BAgMDMAkCAQMCAQYCAQcwBgQB
AQQBAQQrBAL+E8BTe7wRrKoH15PeTm1eXJTu6AKJBw+wXTj/WDIfLoAFNtU4zNqj
2QIVBAAAAAAAAAAAAAIBCKLgzA2Z+KXvAgEC
-----END EC PARAMETERS-----
===sect163r1===
-----BEGIN EC PARAMETERS-----
BgUrgQQAAg==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGhAgEBMCUGByqGSM49AQIwGgICAKMGCSqGSM49AQIDAzAJAgEDAgEGAgEHMC4E
FQe2iCyq76hPlVT/hCi9iOJG0ngq4gQVBxNhLc3ctAqrlGvaKcqR9zr5WK/ZBCsE
A2mXlperQ4l3iVZniVZ/eHp4dqZUAENe20Lvr7KYnVH+/OPICYj0H/iDAhUD////
/////////0iqtonCnKcQJ5sCAQI=
-----END EC PARAMETERS-----
===sect163r2===
-----BEGIN EC PARAMETERS-----
BgUrgQQADw==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGNAgEBMCUGByqGSM49AQIwGgICAKMGCSqGSM49AQIDAzAJAgEDAgEGAgEHMBoE
AQEEFQIKYBkHuMlTyhSB6xBRL3h0SjIF/QQrBAPw66FihqLVfqCZEWjUmUY36DQ+
NgDVH7xscaAJT6LN1UWxHFwMeXMk8QIVBAAAAAAAAAAAAAKS/nfnDBKkI0wzAgEC
-----END EC PARAMETERS-----
===sect193r1===
-----BEGIN EC PARAMETERS-----
BgUrgQQAGA==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIHCAgEBMB0GByqGSM49AQIwEgICAMEGCSqGSM49AQIDAgIBDzBLBBgXhY/repiX
UWnhcfd7QIfeCYrIqRHfewEEGP37Sb/mw6ifrK2qeh5bvHzBwuXYMUeIFAMVABA/
rsdNaW5naHVhUXV3f8Wxke8wBDMEAfSBvF8P+Ep0rWzfb970v2F5YlNy2MDF4QAl
45nykDcSzPPqnjoa0X+wsyAbavfOGwUCGQEAAAAAAAAAAAAAAADH80p3j0Q6zJIO
ukkCAQI=
-----END EC PARAMETERS-----
===sect193r2===
-----BEGIN EC PARAMETERS-----
BgUrgQQAGQ==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIHDAgEBMB0GByqGSM49AQIwEgICAMEGCSqGSM49AQIDAgIBDzBMBBkBY/NaUTfC
zj6m7YZnGQsLxD7NaZd3AnCbBBjJu56JJ9TWTDd+KrKFalsW4++39h1DFq4DFQAQ
t7TWluZ2h1YVF1E3yKFv0NoiEQQzBADZtn0ZLgNnyAPznhp+gsoUplE1Cq5hfo8B
zpQzVgfDBKwp59772coB9Zb5JyJM3s9sAhkBAAAAAAAAAAAAAAABWqtWGwBUE8zU
7pnVAgEC
-----END EC PARAMETERS-----
===sect233k1===
-----BEGIN EC PARAMETERS-----
BgUrgQQAGg==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGMAgEBMB0GByqGSM49AQIwEgICAOkGCSqGSM49AQIDAgIBSjAGBAEABAEBBD0E
AXIyuoU6fnMa8SnyL/QUlWOkGcJr9QpMnW7vrWEmAdtTfezoGbf3D1VaZ8QnqM2b
8Yrrm1bgwRBW+uajAh4AgAAAAAAAAAAAAAAAAAAGnVu5FbzUbvsa1fFzq98CAQQ=
-----END EC PARAMETERS-----
===sect233r1===
-----BEGIN EC PARAMETERS-----
BgUrgQQAGw==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIG/AgEBMB0GByqGSM49AQIwEgICAOkGCSqGSM49AQIDAgIBSjA5BAEBBB1mZH7e
bDMsf4wJI7tYITszOyDpzkKB/hFffY+QrQMVAHTVn/B/a0E9DqFLNEsgotsEm1DD
BD0EAPrJ38usgxO7ITnxu3Vf72W8OR+LNvj463Nx/VWLAQBqCKQZAzUGeOWFKL6/
igvv+GenyjZxb34B+BBSAh4BAAAAAAAAAAAAAAAAAAAT6XTnL4ppIgMdJgPP4NcC
AQI=
-----END EC PARAMETERS-----
===sect239k1===
-----BEGIN EC PARAMETERS-----
BgUrgQQAAw==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGNAgEBMB4GByqGSM49AQIwEwICAO8GCSqGSM49AQIDAgICAJ4wBgQBAAQBAQQ9
BCmgtqiHqYPpcwmIpocnqLLRJsRMwsx7KmVVGTA13HYxCATxLlSb2wEcEDCJ5zUQ
rLJ1/DEqXca3ZVPwygIeIAAAAAAAAAAAAAAAAAAAWnn+xny26R8cHagA5HilAgEE
-----END EC PARAMETERS-----
===sect283k1===
-----BEGIN EC PARAMETERS-----
BgUrgQQAEA==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGmAgEBMCUGByqGSM49AQIwGgICARsGCSqGSM49AQIDAzAJAgEFAgEHAgEMMAYE
AQAEAQEESQQFAyE/eMpEiD8aO4Fi8YjlU80mXyPBVnoWh2kTsMKsJFhJKDYBzNo4
DxyeMY2Q+V0H5UJv6H5FwOgYRpjkWWI2TjQRYXfdIlkCJAH/////////////////
/////+muLtB1dyZd/3+URR4GHhY8YQIBBA==
-----END EC PARAMETERS-----
===sect283r1===
-----BEGIN EC PARAMETERS-----
BgUrgQQAEQ==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIHgAgEBMCUGByqGSM49AQIwGgICARsGCSqGSM49AQIDAzAJAgEFAgEHAgEMMEAE
AQEEJAJ7aArIuFltpaSvihmgMD/Kl/12RTCfoqWBSFr2Jj4xO3mi9QMVAHfisHNw
6w+DKm3Vti38iM0Gu4S+BEkEBfk5JY233ZDhk0+McLDf7C7tJbhVfqycgOLhmPjN
vs2GsSBTA2doVP4kFBy5j+bUsg0CtFFv9wI1Dt2wgmd5yBPw30W+gRL0AiQD////
///////////////////vkDmWYPyTipAWWwQqfO+tswcCAQI=
-----END EC PARAMETERS-----
===sect409k1===
-----BEGIN EC PARAMETERS-----
BgUrgQQAJA==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIHNAgEBMB0GByqGSM49AQIwEgICAZkGCSqGSM49AQIDAgIBVzAGBAEABAEBBGkE
AGDwX2WPScGtOrGJD3GEIQ79CYfjB8hMJ6zPuPn2fMLEYBietaqqYu4iLrGzVUDP
6QI3RgHjaQULfE5CrLodrL8EKZw0YHgvkY6kJ+YyUWXp6hDj2l9sQunFUhWqnKJ6
WGPsSNjgKGsCM3/////////////////////////////////+X4Oy1OogQA7EVX1e
0+PnyltLXIO44B5fzwIBBA==
-----END EC PARAMETERS-----
===sect409r1===
-----BEGIN EC PARAMETERS-----
BgUrgQQAJQ==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIIBFwIBATAdBgcqhkjOPQECMBICAgGZBgkqhkjOPQECAwICAVcwTwQBAQQzIaXC
yO6f61xLmnU7e0drf9ZCLvHz3WdHYfqZ1qwnyKmhl7Jygi9s1XpVqk9QrjF7E1Rf
AxUAQJm1pFf51p95IT0JTEvNTUJiIQsEaQQBXUhg0Ijds0lrDGBkdWJgRBzeSvF3
HU2wH/5bNOWXA9wlWoaKEYBRVgOuq2B5TlS7eZanAGGxz6tr5fMrv6eDJO0QanY2
ucWnvRmNAViqT1SI0I84UU8f30tPQNIYGzaBw2S6AnPHBgI0AQAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAB4qrWphLzMwe+X6R8PJ4FL4OBZM032aIRcwIBAg==
-----END EC PARAMETERS-----
===sect571k1===
-----BEGIN EC PARAMETERS-----
BgUrgQQAJg==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIIBEwIBATAlBgcqhkjOPQECMBoCAgI7BgkqhkjOPQECAwMwCQIBAgIBBQIBCjAG
BAEABAEBBIGRBAJut6hZkj+8ghiWMfgQP+SsnKKXABLV1GAkgEgBhBykQ3CVhJOy
BeZH2jBNtM6wjLvRujlJR3b7mItHF03KiMfilFKDoByJcgNJ3IB/T783T0rq3jvK
lTFN1YzsnzB6VP/GHvwAbYosnUl5wKxErqdPvru593Ku3LYgsBp7p68bMgQwyFkZ
hPYBzUwUPvHHowJIAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
ExhQ4fGaY+SzkajbkX9BOLYw2Evl1jk4HpHetFz+d49jfBABAgEE
-----END EC PARAMETERS-----
===sect571r1===
-----BEGIN EC PARAMETERS-----
BgUrgQQAJw==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIIBcQIBATAlBgcqhkjOPQECMBoCAgI7BgkqhkjOPQECAwMwCQIBAgIBBQIBCjBk
BAEBBEgC9A5+IiHyld4pcRe389YvXGqX/8uM7/HNa6jOSpoYrYT/q72O+lkzK+et
Z1ambilK/RhaeP8SqlIOTec5usoMf/7/fylVcnoDFQAqoFj3Og4zq0hrD2EEEMU6
fxMjEASBkQQDAwAdNLhWKWwWwNQNPNd1CpPR0pVfqAql9A/I23sqvb3lOVD0wNKT
zdcRo1tn+xSZrmADhhTxOUq/o7TIUNkn4ed2nI7sLRkDe/JzQtpjm23M//63PWnX
jGwnpgCcu8oZgPhTOSHopoRCPkO6sIpXYpGvj0YbsqizUx0vBIXBmxbi8VFuI908
GkgnrxuKwVsCSAP//////////////////////////////////////////////+Zh
zhj/VZhzCAWbGGgjhR7H3ZyhFh3pPVF01m6Dgum7L+hORwIBAg==
-----END EC PARAMETERS-----
===c2pnb163v1===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMAAQ==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIG3AgEBMCUGByqGSM49AQIwGgICAKMGCSqGSM49AQIDAzAJAgEBAgECAgEIMEQE
FQclRrVDUjSkIuB4lnX0MsiUNd5SQgQUyVF9BtUkDTz/OMdLILbNTW+d1NkDFQDS
wPsVdghg3vHu9NaW5naHVhUXVAQrBAevaZiVRhA9eTKfzD10iA8zu+gDywHsIyEb
WWat6h0/h/fqWEiu8LfKnwIVBAAAAAAAAAAAAAHmD8iCHMdNrq/BAgEC
-----END EC PARAMETERS-----
===c2pnb163v2===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMAAg==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIG4AgEBMCUGByqGSM49AQIwGgICAKMGCSqGSM49AQIDAzAJAgEBAgECAgEIMEUE
FQEIs553xLEIvtmB7Q6JDhF8URzwcgQVBmes6zivTkiMQHQz/65PHIEWON8gAxUA
U4FMBQ1E1pbmdodWFRdYDKTin/0EKwQAJCZuTrUQbQqWTZLEhg4mcdubbMUHn2hN
32aExc0liziQAhsjht/Rn8UCFQP////////////99k3hFRrbt48QpwIBAg==
-----END EC PARAMETERS-----
===c2pnb163v3===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMAAw==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIG4AgEBMCUGByqGSM49AQIwGgICAKMGCSqGSM49AQIDAzAJAgEBAgECAgEIMEUE
FQelJsY9PiWiVqAHaZ9UR+Mq5Fa1DgQVA/cGF5jrmeI4/W8b+VtI/utIVCUrAxUA
UMvx2VypTWluZ2h1YVF18Wo2o7gEKwQC+fh7fFdNC97PiiLmUkd1+YzevcsFuTVZ
DBVeF+pI6z/zcYuJPfWaBdACFQP////////////+Gu4UDxEK/5YTCQIBAg==
-----END EC PARAMETERS-----
===c2pnb176v1===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMABA==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGnAgEBMCUGByqGSM49AQIwGgICALAGCSqGSM49AQIDAzAJAgEBAgECAgErMDAE
FuTm2ymVBlxAfZ05uNCWe5ZwS6jpyQsEFl3aRwq+ZBTejsEzrijpu9f87Arg//IE
LQSNFsKGZ5i2APnwi7So6GDzKYzgSleYb6RTnC2t3da6tRZ9YbQ24dkrsWpWLAIV
AQCSU3OX7KT2FFeZ1isKGc4G/iatAgMA/24=
-----END EC PARAMETERS-----
===c2tnb191v1===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMABQ==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIG/AgEBMB0GByqGSM49AQIwEgICAL8GCSqGSM49AQIDAgIBCTBLBBgoZlN7Z2dS
Y2po9WVU4SZAJ2tknvdSYmcEGC5F71cfAHhvZ7AIG5SVo9lUYvXeCqGF7AMVAE4T
ylQnRNaW5naHVhUXVS8nmoyEBDEENrPa+KIyBvnE8pnXshqcNpE38shK4aoNdlvn
NDOz+V4zKTLnDqJFyiQY6g75gBj7AhhAAAAAAAAAAAAAAAAEog6Qw5BnyJO7uaUC
AQI=
-----END EC PARAMETERS-----
===c2tnb191v2===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMABg==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIG/AgEBMB0GByqGSM49AQIwEgICAL8GCSqGSM49AQIDAgIBCTBLBBhAECh3TXd3
x7dmbRNm6kMgcSdPif8B5xgEGAYgBI0ovL0DtiScmRgrfIzRlwDDYsRqAQMVAAhx
7y/vJNaW5naHVhUXWL7g2VwVBDEEOAmyt8wbKMxah5JqrYP9KHiegeLJ478QF0ND
hmJtFPPb8Bdg2SE6PhzzeuxDfWaKAhggAAAAAAAAAAAAAABQUIy4n2UoJOBrgXMC
AQQ=
-----END EC PARAMETERS-----
===c2tnb191v3===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMABw==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIG/AgEBMB0GByqGSM49AQIwEgICAL8GCSqGSM49AQIDAgIBCTBLBBhsAQdHVgmR
IiIQVpEcd9d+d6d35+fnf8sEGHH+Gvkmz4R5ie/vjbRZ9mOU2Q8yrT8V6AMVAOBT
US3GhNaW5naHVhUXUGeueG0fBDEEN11M4k/eQ0SJ3odG5xeGAVAJ5m44qSbdVFo5
F2GWV12YWZk2bmrTTOCnfNcSewa+AhgVVVVVVVVVVVVVVVVhDAsZaBK/tiiKPqMC
AQY=
-----END EC PARAMETERS-----
===c2pnb208w1===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMACg==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGiAgEBMCUGByqGSM49AQIwGgICANAGCSqGSM49AQIDAzAJAgEBAgECAgFTMB8E
AQAEGshhntRaYuYhLhFgNJ4r+oREOfr8Kj/RY4+eBDUEif375Kvhk9+VWezwesDO
eFVOJ4TrjB7RpXoPVbUaBueOmsOKA1/1INiwF4G+saa7CGF94wIZAQG6+VyXI8V7
bCHaLv8tXtWIvdVxfiEvnQIDAP5I
-----END EC PARAMETERS-----
===c2tnb239v1===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMACw==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIHdAgEBMB0GByqGSM49AQIwEgICAO8GCSqGSM49AQIDAgIBJDBXBB4yAQhXB3xU
MRI6RrgIkGdW9UNCPo0nh3V4Eld4rHYEHnkECPLu2vOSsBLt77M5LzD0MnwMo/Mf
w4PEIqqMFgMVANNLmk1pbmdodWFRdcpxuSC/77BdBD0EV5JwmPqTLnwKltP9W3Bu
9+X1wVbha358hgOFUukdYdjuUHfDP+z28aFrJo3kacPHdE6pqXFkn8epYWMFAh4g
AAAAAAAAAAAAAAAAAAAPTUL/4UkqSZPxytZm5EcCAQQ=
-----END EC PARAMETERS-----
===c2tnb239v2===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMADA==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIHdAgEBMB0GByqGSM49AQIwEgICAO8GCSqGSM49AQIDAgIBJDBXBB5CMAF3V6dn
+uQjmFabdGMl1FMTrwdmJmR5t1ZU5l8EHlA36mVBls/wzYKywUovzy4/+HdShbVF
ci8D6s23SwMVACqmmC/fpNaW5naHVhUXXSZnJyd9BD0EKPnQTpAAacjcR6CFNP52
0rkAt9fvMfVwnyAMTKIFVmczTEWv87WgO62d114scamTYlZ9VFP3+m4ifsgzAh4V
VVVVVVVVVVVVVVVVVVU8byiFJZwx4/zfFUYkUi0CAQY=
-----END EC PARAMETERS-----
===c2tnb239v3===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMADQ==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIHdAgEBMB0GByqGSM49AQIwEgICAO8GCSqGSM49AQIDAgIBJDBXBB4BI4d0Zmpn
dm1mdvd45na2aZkXZmbmh2Zth2bGap8EHmqUGXe6n2pDUZms/FEGftWH9RnF7LVB
uORBEd4dQAMVAJ4Hb01pbmdodWFRdeEen913+SBBBD0EcPbp0E0onE6JkTzjUwv9
6QOXfUKxRtU5vxveTpySLloOr25eEwW5AE3OXA7X/lmjVgjzODfIFtgLefRhAh4M
zMzMzMzMzMzMzMzMzMysSRLS2d+QPvmIi4oOTP8CAQo=
-----END EC PARAMETERS-----
===c2pnb272w1===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMAEA==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIHjAgEBMCUGByqGSM49AQIwGgICARAGCSqGSM49AQIDAzAJAgEBAgEDAgE4MEgE
IpGgkfA7X7pKssz0nE7dIg+wKHEtQr51KyxACU26zbWG+yAEInFn78krsuPOfIqq
/zThKpxVcAPXxzpvrwA/mfbMhILlQPcERQRhCLq7LO6894cFigVsvgz+Yi13I6KJ
4IoHrhPvDRDRcd2NEMdpVxaFHu9rp/aHLmFC+9JBuDD/Xvys7MqwXgIAXd6dIwIh
AQD69RNU4OOeSJLfbjGccsgWFgP6Rap7mYoWe48eYpUhAgMA/wY=
-----END EC PARAMETERS-----
===c2pnb304w1===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMAEQ==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIH3AgEBMCUGByqGSM49AQIwGgICATAGCSqGSM49AQIDAzAJAgEBAgECAgELMFAE
Jv0NaTFJoRj2Uebc5oAghTd+X4gtG1ELRBYAdMEogHg2WgOWyOaBBCa925flVaUK
kI5DsBx5jqXapniPHqJ5Tvz1cWa4wUA5YB5VgnNAvgRNBBl7B4Rem+LZatsPXzx/
LP+9ej64tv7DXH/Wfybd9ihaZE90CiYU4Z++t24NoXFRfs9AG1Aom/AUEDKIUnqb
QWoQXoAmC1Sf3BuSwDsCJQEB1VZXKqusgAEB1VZXKqusgAECLVyR3Rc/j7Vh2miZ
FkRDBR0CAwD+Lg==
-----END EC PARAMETERS-----
===c2tnb359v1===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMAEg==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIIBKAIBATAdBgcqhkjOPQECMBICAgFnBgkqhkjOPQECAwICAUQwdQQtVmdnamVL
IHVPNW6pIBfZRlZ8RmdVVvGVVqBGFrVn0iOl4FZW+1SQFqlmVqVXBC0kcuLQGXxJ
Nj8f5/W22wddUraUfRNdjKRFgF05vDRWJgiWh3QrYynnBoAjGYgDFQArNUkgtyTW
luZ2h1YVF1hboTMtxgRbBDwljvMEd2fn7eDx/ap52u44QTZqEy4WOs7U7SQB35xr
3N6Y6OcHwHoiObGwl1PX4IUpVHBIEh6clfN5HdgEljlI80+ue/ROqCNl3Hho/lfk
ri3iETBaQHEEvQItAa8oa8oa8oa8oa8oa8oa8oa8oa8oa8n7j2uFxVaJLCCn65ZP
53GedPSQdY07AgFM
-----END EC PARAMETERS-----
===c2pnb368w1===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMAEw==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIIBHwIBATAlBgcqhkjOPQECMBoCAgFwBgkqhkjOPQECAwMwCQIBAQIBAgIBVTBg
BC7g0u4lCVIG9eKk+e0inx8lbnmg4rRVlw2NDYZb2Ud4xXbWLwq3UZzNKhqQauMN
BC78EhfUMgqQRSx2CljtzTDI3QabPDRFODejTtUMtUkX4cIRLYTRZPRE+PdHhgRq
BF0EEIXidVOB3MzjwVV6+hDC8MDCglZGxbNKOUy8+ovBayLn54npJ74hbwLh+xNq
X3s+sb3cumLV2LIFm1JXl/xzgixZBZxiOkX/OEPO6Ph80YVa2qgeKgdQuA/aIxAC
LQEAkFEtqa9ysINJ2Ypd1MewUy7KUc4D4tEPO3rFeb2H6QmuQKbxMenPzlvZZwID
AP9w
-----END EC PARAMETERS-----
===c2tnb431r1===
-----BEGIN EC PARAMETERS-----
BggqhkjOPQMAFA==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIIBPgIBATAdBgcqhkjOPQECMBICAgGvBgkqhkjOPQECAwICAXgwcAQ2GoJ+8A3W
/A4jTK8EbGpdioU5WyNsxK0s8yoMrb3J3fYgsOuZBtCVf2xv6s1hVGjfEE3ils2P
BDYQ2bSj2QR9ixVDWav7G39UhbBM64aCN93J3tqYKmeaWpGbYm1OUKjdcxsQepli
OB+12Ae/JhgEbQQSD8BdPGepneFh0vQJJiL+ynAb5PUPR1hxToqHu/KmWO+MIefF
7+llNh9sKZnAwkew29cM5rcg0K+JA6lvjV+iwlV0XTxFGzAsk0bZt+SF57zkH2tZ
Hz6Pat3LsLxML5R6feGom2JdalmLN2ACNQNANANANANANANANANANANANANANANA
NANANAMjwxP6tQWJcDtexo01h/7GDRYcwUnBrUqRAgInYA==
-----END EC PARAMETERS-----
===wap-wsg-idm-ecid-wtls1===
-----BEGIN EC PARAMETERS-----
BgVnKwEEAQ==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MF4CAQEwHAYHKoZIzj0BAjARAgFxBgkqhkjOPQECAwICAQkwBgQBAQQBAQQfBAFm
eXmkC6SX5dXCcHgGFwD0S0rx7MJjDgh4XOvMFQIPAP/////////9v5GvbepzAgEC
-----END EC PARAMETERS-----
===wap-wsg-idm-ecid-wtls3===
-----BEGIN EC PARAMETERS-----
BgVnKwEEAw==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MHkCAQEwJQYHKoZIzj0BAjAaAgIAowYJKoZIzj0BAgMDMAkCAQMCAQYCAQcwBgQB
AQQBAQQrBAL+E8BTe7wRrKoH15PeTm1eXJTu6AKJBw+wXTj/WDIfLoAFNtU4zNqj
2QIVBAAAAAAAAAAAAAIBCKLgzA2Z+KXvAgEC
-----END EC PARAMETERS-----
===wap-wsg-idm-ecid-wtls4===
-----BEGIN EC PARAMETERS-----
BgVnKwEEBA==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGPAgEBMBwGByqGSM49AQIwEQIBcQYJKoZIzj0BAgMCAgEJMDcEDjCIJQym58f+
ZJzoWCD3BA7ovuTT4iYHRBiL4OnHIwMVABDnI6sU1pbmdodWFRdW/r+Py0mpBB8E
AJ1zYW819KsUB9c1YsEPAKUoMCd5WO6E0TFe0xiGAg8BAAAAAAAAANnM7Io55W8C
AQI=
-----END EC PARAMETERS-----
===wap-wsg-idm-ecid-wtls5===
-----BEGIN EC PARAMETERS-----
BgVnKwEEBQ==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIG3AgEBMCUGByqGSM49AQIwGgICAKMGCSqGSM49AQIDAzAJAgEBAgECAgEIMEQE
FQclRrVDUjSkIuB4lnX0MsiUNd5SQgQUyVF9BtUkDTz/OMdLILbNTW+d1NkDFQDS
wPsVdghg3vHu9NaW5naHVhUXVAQrBAevaZiVRhA9eTKfzD10iA8zu+gDywHsIyEb
WWat6h0/h/fqWEiu8LfKnwIVBAAAAAAAAAAAAAHmD8iCHMdNrq/BAgEC
-----END EC PARAMETERS-----
===wap-wsg-idm-ecid-wtls6===
-----BEGIN EC PARAMETERS-----
BgVnKwEEBg==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGLAgEBMBoGByqGSM49AQECDwDbfCq/YuNeZoB2vq0gizA3BA7bfCq/YuNeZoB2
vq0giAQOZZ74ugQ5Fu7eiRFwKyIDFQAA9QsCjk1pbmdodWFRdSkEcng/sQQdBAlI
cjmZWl7na1X5wvCYqJzlr4ckwKI+Dg/3dQACDwDbfCq/YuNedijfrGVhxQIBAQ==
-----END EC PARAMETERS-----
===wap-wsg-idm-ecid-wtls7===
-----BEGIN EC PARAMETERS-----
BgVnKwEEBw==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGvAgEBMCAGByqGSM49AQECFQD////////////////////+//+sczBDBBT/////
///////////////+//+scAQUtOE00/tZ64urVydJBGZNWvUDiLoDFQC5m5mwmbMj
4CcJpNaW5naHVhUXUQQpBFLcsDQpOhF+H0/xGzD3GZ0xRM5t/q/+8uMx8pbgcfoN
+Zgs/qfUPy4CFQEAAAAAAAAAAAAANR7nhqgY86GhawIBAQ==
-----END EC PARAMETERS-----
===wap-wsg-idm-ecid-wtls8===
-----BEGIN EC PARAMETERS-----
BgVnKwEECA==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MFoCAQEwGgYHKoZIzj0BAQIPAP////////////////3nMAYEAQAEAQMEHQQAAAAA
AAAAAAAAAAAAAQAAAAAAAAAAAAAAAAACAg8BAAAAAAAAAezqVRrYN+kCAQE=
-----END EC PARAMETERS-----
===wap-wsg-idm-ecid-wtls9===
-----BEGIN EC PARAMETERS-----
BgVnKwEECQ==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MHICAQEwIAYHKoZIzj0BAQIVAP///////////////////////ICPMAYEAQAEAQME
KQQAAAAAAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAACAhUBAAAA
AAAAAAAAAc3JiuDi3ldKvzMCAQE=
-----END EC PARAMETERS-----
===wap-wsg-idm-ecid-wtls10===
-----BEGIN EC PARAMETERS-----
BgVnKwEECg==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIGMAgEBMB0GByqGSM49AQIwEgICAOkGCSqGSM49AQIDAgIBSjAGBAEABAEBBD0E
AXIyuoU6fnMa8SnyL/QUlWOkGcJr9QpMnW7vrWEmAdtTfezoGbf3D1VaZ8QnqM2b
8Yrrm1bgwRBW+uajAh4AgAAAAAAAAAAAAAAAAAAGnVu5FbzUbvsa1fFzq98CAQQ=
-----END EC PARAMETERS-----
===wap-wsg-idm-ecid-wtls11===
-----BEGIN EC PARAMETERS-----
BgVnKwEECw==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIG/AgEBMB0GByqGSM49AQIwEgICAOkGCSqGSM49AQIDAgIBSjA5BAEBBB1mZH7e
bDMsf4wJI7tYITszOyDpzkKB/hFffY+QrQMVAHTVn/B/a0E9DqFLNEsgotsEm1DD
BD0EAPrJ38usgxO7ITnxu3Vf72W8OR+LNvj463Nx/VWLAQBqCKQZAzUGeOWFKL6/
igvv+GenyjZxb34B+BBSAh4BAAAAAAAAAAAAAAAAAAAT6XTnL4ppIgMdJgPP4NcC
AQI=
-----END EC PARAMETERS-----
===wap-wsg-idm-ecid-wtls12===
-----BEGIN EC PARAMETERS-----
BgVnKwEEDA==
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MIHIAgEBMCgGByqGSM49AQECHQD/////////////////////AAAAAAAAAAAAAAAB
MDwEHP////////////////////7///////////////4EHLQFCoUMBLOr9UEyVlBE
sLfXv9i6Jws5QyNV/7QEOQS3Dgy9a7S/fzITkLlKA8HTVsIRIjQygNYRXB0hvTdj
iLX3I/tMIt/mzUN1oFoHR2RE1YGZhQB+NAIdAP//////////////////FqLguPA+
E90pRVxcKj0CAQE=
-----END EC PARAMETERS-----
===Oakley-EC2N-3===
-----BEGIN EC PARAMETERS-----
BgA=
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MHACAQEwHQYHKoZIzj0BAjASAgIAmwYJKoZIzj0BAgMCAgE+MAgEAQAEAwczjwQp
BAAAAAAAAAAAAAAAAAAAAAAAAAB7AAAAAAAAAAAAAAAAAAAAAAAAAcgCFAKqqqqq
qqqqqqrH88eIG9CGj6hsAgED
-----END EC PARAMETERS-----
===Oakley-EC2N-4===
-----BEGIN EC PARAMETERS-----
BgA=
-----END EC PARAMETERS-----
-----BEGIN EC PARAMETERS-----
MHsCAQEwHQYHKoZIzj0BAjASAgIAuQYJKoZIzj0BAgMCAgFFMAcEAQAEAh7pBDEE
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAYAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAN
AhgA///////////////t+XxE258kILr8p14CAQI=
-----END EC PARAMETERS-----