#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
char *pdf_to_kill;

void show_wait_dialog()

{
    GtkWidget *waitdialog;

    waitdialog = create_waitdialog ();
    gtk_widget_show (waitdialog);
}

int
process_file(char *ms_file)

{
    /* oppenoffice main binary hardcoded for now */
    char cmd[256] = "/usr/lib/openoffice/program/soffice.bin -invisible \"macro:///Tools.MSToPDF.ConvertMSToPDF(";

    /* 
	Openoffice doesn't seem to like being called by exec. Don't know why
    */
    			    
    strcat(cmd, ms_file);
    strcat(cmd, ")\"");
					    
    if (system(cmd))
	return errno;
    return 0;
}

int
call_evince(char *pdf_file)

{
    pid_t pID = fork();
    if (pID < 0) 
    {
	return errno;
    } else
    if (pID == 0)
    {
    	execl("/usr/bin/evince","evince",pdf_file,NULL);
    }
    return (0);
}

void
process_error(int error)

{
}

void
on_filechooserdialog1_response (GtkDialog *dialog, gint response_id, gpointer user_data)
{
    if (response_id == GTK_RESPONSE_OK)
    {
	char *ms_filename;
	char *pdf_filename;
	int err_process;
	
	ms_filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
	// Let it out for now - show_wait_dialog();
	err_process = process_file(ms_filename);
	if (!err_process)
	{
	    pdf_filename = malloc(strlen(ms_filename)+1);
	    pdf_filename = strncpy(pdf_filename, ms_filename, strlen(ms_filename));
	    pdf_filename[strlen(ms_filename)-4]='\0';
	    strcat(pdf_filename,".pdf");
	    gtk_widget_hide_all(GTK_WIDGET(dialog));
	    err_process = call_evince(pdf_filename);
	}
	if (pdf_filename)
	{
	    pdf_to_kill = malloc(strlen(pdf_filename)+1);
	    strcpy(pdf_to_kill,pdf_filename);
	    free (pdf_filename);
	}
	if (err_process)
	    process_error(err_process);
    }
}

