/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    Copyright (C) 2009-2012 Martin Brehm

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/

#ifndef REACT_H
#define REACT_H

#include "xobarray.h"	// Hinzugefgt von der Klassenansicht
#include "xobject.h"
#include "timestep.h"

class CReactTraj : public CxObject
{
public:
	bool m_bTDO;
	int m_iBeginStep;
	int m_iEndStep;
	char *m_sFileName;
	FILE *m_fFile;
	CxWordArray m_waAtoms;
	CReactTraj();
	~CReactTraj();
};

class CReactMol : public CxObject
{
public:
	bool ContainsElement(int i);
	bool m_bEnabled;
	void CalcMass();
	float m_fMass;
	unsigned long m_iColor;
	int m_iIndex;
	void REC_IsConnected(int i);
	bool* m_bAtomMarked;
	bool* m_bBondMarked;
	bool IsConnected(int i, int j);
	bool m_bPrinted;
	void BuildName();
	CReactMol();
	~CReactMol();

	int m_iCreationTime;
	int m_iDestructionTime;
	CxObArray m_oaParents;
	CxObArray m_oaChildren;

	CxWordArray m_waAtoms;
	CxWordArray m_waBonds;
//	CxVec3Array m_vaSnapshot;
	char *m_sName;
};

class CReact : public CxObject
{
public:
	float m_fTDOBleaching;
	int m_iTDOSteps;
	int m_iTDORange;
	int m_iColorElement;
	int m_iColorScheme;
	bool m_bOnlyElemReact;
	int m_iOnlyElem;
	void WriteTrajec(CTimeStep *ts);
	CxObArray m_oaReactTrajectories;
	bool m_bLeaveInert;
	bool m_bWriteSnapshots;
	bool m_bWriteMolTrajec;
	bool m_bWriteReactTrajec;
	bool m_bCreateTDO;
	int m_iReactTrajecRange;
	bool m_bIgnoreRearrange;
	unsigned long ColorFunction(float val, float bleach);
	void Finish();
	void CreateOutput();
	void DumpMolecules();
	void PrintName(int i);
	void ScanBonds(CTimeStep *ts, bool instant);
	void Parse();
	void Create();
	int *m_iBondCounter;
	bool *m_bBonds;
	float m_fBondFactor;
	int m_iWaitSteps;
	CxObArray m_oaMolecules;
	CxWordArray m_waAtomMol;
	void InitMolecules(CTimeStep *ts);
	void ChangeBond(int i, int j, int t, CTimeStep *ts, bool add);
	CReact();
	~CReact();
};

#endif
