# Copyright (C) 2002, LIMSI - extension for the Transcriber program

################################################################

namespace eval text {

   variable msg "Text"
   variable ext ".txt"

   proc export {name} {
     global v
     
     # format for time markers after paragraph 
     #set ft " (%s-%s)"
     set ft ""
     # format for overlapping segments - ex: set fo "\{%s\}(%s)"
     #set fo "{%s\#%s}"
     set fo "< %s >"
     # toggle short turns mode
     set short 1

     set nbOverlap 0

     set channel [open $name w]
     set episode [$v(trans,root) getChilds "element" "Episode"]
     foreach sec [$episode getChilds "element" "Section"] {
       if {[$sec getAttr "type"] == "nontrans"} continue
       set spk1 ""; set txt1 ""; set spk2 ""; set txt2 ""
       set sta1 ""; set end1 ""; set sta2 ""; set end2 ""
       set turns [$sec getChilds "element" "Turn"]
       for {set nt 0} {$nt < [llength $turns]} {incr nt} {
	 set tur [lindex $turns $nt]
	 set sta [format %.3f [$tur getAttr "startTime"]]
	 set end [format %.3f [$tur getAttr "endTime"]]
	 set spkLst [$tur getAttr "speaker"]
	 set nbSpk [llength $spkLst]
	 # 1st speaker is still present
	 if {$spk1 != "" && [set i [lsearch $spkLst $spk1]] >= 0 && (!$short || ($i==0 && $spk2==""))} {
	   # if previous 2nd speaker finished
	   if {$spk2 != ""} {
	     if {[lsearch $spkLst $spk2] < 0 || $short} {
	       append txt2 "[format $ft $sta2 $end2]\n"
	       set spk2 ""; set sta2 ""; set end2 ""
	       if {$short} {
		 print1
		 set txt1 "[::speaker::name $spk1]:"
		 set sta1 $sta
		 print2
	       }
	     } else {
	       set end2 $end
	     }
	   }
	   set end1 $end
	   # if there is a new 2nd speaker
	   if {$nbSpk == 2 && $spk2 == ""} {
	     set spk2 [lindex $spkLst [expr 1-$i]]
	     set sta2 $sta; set end2 $end
	     append txt2 "[::speaker::name $spk2]:"
	   }
	 } else {
	   # 1st speaker changed
	   print1
	   if {$spk2 != "" && [set i [lsearch $spkLst $spk2]] >= 0 && (!$short || ($i==0))} {
	     # 2nd speaker becomes 1st speaker
	     set spk1 $spk2; set txt1 $txt2; set sta1 $sta2; set end1 $end
	   } else {
	     # 2nd speaker also finished
	     print2
	     # choose 1st speaker still present next turn if possible
	     set i 0
	     if {!$short && $nbSpk == 2 && $nt+1 < [llength $turns]} {
	       set spkLst2 [[lindex $turns [expr $nt+1]] getAttr "speaker"]
	       if {[lsearch $spkLst2 [lindex $spkLst 1]] >= 0} {
		 set i 1
	       }
	     }
	     if {$nbSpk == 0} continue
	     set spk1 [lindex $spkLst $i]
	     set txt1 "[::speaker::name $spk1]:"	     
	     set sta1 $sta; set end1 $end
	   }
	   # 2nd speaker is the other one (or is empty)
	   if {$nbSpk == 1} {
	     set spk2 ""; set txt2 ""
	   } else {
	     set spk2 [lindex $spkLst [expr 1-$i]]
	     set txt2 "[::speaker::name $spk2]:"
	     set sta2 $sta; set end2 $end
	   }
	 }
	 set crt 1
	 set s1 ""; set s2 ""
	 foreach chn [$tur getChilds] {
	   set s ""
	   if {[$chn class] == "data"} {
	     set s [string trim [$chn getData]]
	   } elseif {[$chn class] == "element"} {
	     switch [$chn getType] {
	       "Who" {
		 set nb [$chn getAttr "nb"]
		 if {$nb == 1} {
		   incr nbOverlap
		 } 
		 set crt [expr {($nb == $i+1) ? 1 : 2}]
	       }
	       "Event" - "Comment" {
		 #set s [StringOfEvent $chn]
	       }
	       "Sync" {
		 if {$nbSpk == 2 && $short} {
		   set syn [format %.3f [$chn getAttr "time"]]
		   if {$syn > $sta} {
		     append txt1 " [format $fo $s1 $nbOverlap]"
		     append txt2 " [format $fo $s2 $nbOverlap]"
		     set end1 $syn; set end2 $syn
		     print1; print2
		     set sta1 $syn; set sta2 $syn
		     set end1 $end; set end2 $end
		     set txt1 "[::speaker::name $spk1]:"
		     set txt2 "[::speaker::name $spk2]:"
		     set s1 ""; set s2 ""
		   }
		 }
	       }
	     }
	   }
	   if {$s != ""} {
	     if {[set s$crt] != ""} {
	       append s$crt " "
	     }
	     append s$crt $s
	   }
	 }
	 if {$nbSpk == 2} {
	   append txt1 " [format $fo $s1 $nbOverlap]"
	   append txt2 " [format $fo $s2 $nbOverlap]"
	 } else {
	   if {$s1 != ""} {
	     append txt1 " $s1"
	   }
	 }
       }
       print1
       print2
     }
     close $channel
   }

   proc print1 {} {
     uplevel {
       if {$txt1 != ""} {
	 puts $channel "$txt1[format $ft $sta1 $end1]"
	 set txt1 ""
       }
     }
   }

   proc print2 {} {
     uplevel {
       if {$txt2 != ""} {
	 if {$sta2 != ""} {
	   puts $channel "$txt2[format $ft $sta2 $end2]"
	   set sta2 ""
	 } else {
	   puts -nonewline $channel $txt2
	 }
	 set txt2 ""
       }
     }
   }
}
