# -*- coding: utf-8 -*-
"""
このマクロは Wiki ページ一式の目次 (ToC) を簡単かつ荒っぽく作成する
例です。
"""

TOC = [('TracGuide',                    'Index'),
       ('TracInstall',                  'インストール'),
       ('TracUpgrade',                  'アップグレード'),
       ('TracIni',                      '設定ファイル'),
       ('TracAdmin',                    '管理ツール'),
       ('TracBackup',                   'バックアップ'),
       ('TracLogging',                  'ログ'),
       ('TracPermissions' ,             'アクセス権'),
       ('TracWiki',                     'Wiki'),
       ('WikiFormatting',               'Wiki 文法'),
       ('TracTimeline',                 'タイムライン'),
       ('TracBrowser',                  'リポジトリブラウザ'),
       ('TracChangeset',                'チェンジセット'),
       ('TracRoadmap',                  'ロードマップ'),
       ('TracTickets',                  'チケット'),
       ('TracQuery',                    'カスタムクエリ'),
       ('TracReports',                  'レポート'),
       ('TracRss',                      'RSS 対応'),
       ('TracNotification',             'メール通知'),
       ('TracInterfaceCustomization',   'UIのカスタマイズ'),
       ('TracPlugins',                  'プラグイン'),
       ]

def execute(hdf, args, env):
    html = '<div class="wiki-toc">' \
           '<h4>Table of Contents</h4>' \
           '<ul>'
    curpage = '%s' % hdf.getValue('wiki.page_name', '')
    lang, page = '/' in curpage and curpage.split('/', 1) or ('', curpage)
    for ref, title in TOC:
        if page == ref:
            cls =  ' class="active"'
        else:
            cls = ''
        html += '<li%s><a href="%s">%s</a></li>' \
                % (cls, env.href.wiki(lang+ref), title)
    return html + '</ul></div>'
