%define name	tptime
%define	version 0.5
%define release	1mdk

Summary: 	  Calculator-like program for Julian-Gregorian date conversions
Name: 		%{name}
Version: 	%{version}
Release:	%{release}
Group: 		Sciences/Other
License: 	GPL
Source: 	%{name}-%{version}.tar.bz2
URL:      http://starstones.free.fr
BuildRoot: 	%_tmppath/%name-buildroot
Prefix: 	%{_prefix}

%description
TPTIME is a calculator-like program that performs conversions
between Gregorian date and Julian days, modified Julian days,
and truncated Julian days with the different origins used by
TOPEX/POSEIDON and other satellites (NASA, CNES, CCSDS).
It also provides date of given cycle, pass of TOPEX/POSEIDON,
and vice-versa.

%prep
%__rm -rf $RPM_BUILD_ROOT

%setup -q
touch `find . -type f`

%build
%configure
%make

%install
%make  DESTDIR=$RPM_BUILD_ROOT  install

%__mkdir_p $RPM_BUILD_ROOT%{_iconsdir}
%__mkdir_p $RPM_BUILD_ROOT%{_liconsdir}
%__mkdir_p $RPM_BUILD_ROOT%{_miconsdir}
%__cp pixmaps/32x32/*.png $RPM_BUILD_ROOT%{_iconsdir}
%__cp pixmaps/48x48/*.png $RPM_BUILD_ROOT%{_liconsdir}
%__cp pixmaps/16x16/*.png $RPM_BUILD_ROOT%{_miconsdir}

%__mkdir_p $RPM_BUILD_ROOT%{_menudir}
%__cat > $RPM_BUILD_ROOT%{_menudir}/%{name} <<"EOF"
?package(%{name}): \
command="%{_bindir}/tptime" \
title="Tptime" \
longtitle="Calculator-like program for Julian-Gregorian date conversions" \
needs="x11" \
icon="tptime.png" \
section="Applications/Sciences/Other"
EOF

%post
%{update_menus}

%postun
%{clean_menus}


%clean
%__rm -rf $RPM_BUILD_ROOT

%files
%defattr (-,root,root)
%doc NEWS README COPYING AUTHORS TODO ChangeLog doc/en/*.html
%attr (0755,root,root) %_bindir/*
%attr (0755,root,root) %dir %_datadir/pixmaps/%name
%attr (0644,root,root)  %_datadir/pixmaps/%name/*.xpm
%attr (0644,root,root) %{_menudir}/*
%attr (0644,root,root) %{_iconsdir}/*.png
%attr (0644,root,root) %{_liconsdir}/*.png
%attr (0644,root,root) %{_miconsdir}/*.png


%changelog

* Mon Sep 10 2001 Pierre-Michel THEVENY <pmth@free.fr> 0.5-1mdk
- First built of version 0.5

* Thu Jul 19 2001 Pierre-Michel THEVENY <pmth@free.fr> 0.4-2mdk
- Use bz2 archive instead tar.gz for building

* Mon Jul 16 2001 Pierre-Michel THEVENY <pmth@free.fr> 0.4-1mdk
- First built of version 0.4 on Mandrake 8.0
- Change Summary

* Mon Jun 18 2001 Pierre-Michel THEVENY <pmth@free.fr> 0.3-1mdk
- First built of version 0.3 on Mandrake 8.0
- Change description

* Tue Jun 5 2001 Pierre-Michel THEVENY <pmth@free.fr> 0.2-1mdk
- First built of version 0.2 on Mandrake 8.0

* Tue Jun 5 2001 Pierre-Michel THEVENY <pmth@free.fr> 0.1-1mdk
- First built on Mandrake 8.0

