// Copyright (C) 2002 Zbigniew Leyk (zbigniew.leyk@anu.edu.au)
//                and David E. Stewart (david.stewart@anu.edu.au)
//                and Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef MX_GIVENS_INC
#define MX_GIVENS_INC

#include "Vec.h"
#include "Mat.h"

namespace Torch {

/**
   Givens matrix operations routines.
   Routines for calculating and applying Givens rotations for/to
   vectors and also to matrices by row and by column.
   
   Based on the "Meschach Library", available at the
   anonymous ftp site thrain.anu.edu.au in the directory
   pub/meschach.
   
   @author David E. Stewart (david.stewart@anu.edu.au)
   @author Zbigniew Leyk (zbigniew.leyk@anu.edu.au)
   @author Ronan Collobert (collober@iro.umontreal.ca)
*/
//@{

/** Returns #c#, #s# parameters for Givens rotation
    to eliminate #y# in the vector #[ x y ]'#.
*/
void mx_givens(real x, real y, real * c, real * s);

/** Apply Givens rotation to #x#'s #i# and #k# components.
 */
void mx_rot_vec(Vec * x, int i, int k, real c, real s, Vec * out);

/** Premultiply #mat# by givens rotation described by #c#,#s#.
 */
void mx_rot_rows(Mat * mat, int i, int k, real c, real s, Mat * out);

/** Postmultiply #mat# by givens rotation described by #c#,#s#.
 */
void mx_rot_cols(Mat * mat, int i, int k, real c, real s, Mat * out);

//@}


}

#endif
