// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "Measurer.h"
#include "DataSet.h"

namespace Torch {

Measurer::Measurer(DataSet *data_, FILE *file_)
{
  measure = NULL;
  file = file_;
  file_is_opened = false;
  data = data_;
}

Measurer::Measurer(DataSet *data_, const char *filename)
{
  measure = NULL;
  if( (file = fopen(filename, "w")) == NULL)
    error("Measurer: cannot open the file <%s>", filename);
  file_is_opened = true;
  data = data_;
}

void Measurer::reset()
{
}

void Measurer::measureEx()
{
}

void Measurer::measureIter()
{
}

void Measurer::measureEnd()
{
}

Measurer::~Measurer()
{
  if(file_is_opened)
    fclose(file);
}

}

