// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include "Grammar.h"

namespace Torch {

Grammar::Grammar(int n_words_)
{
  n_words = n_words_;
  words = (int*)xalloc(sizeof(int)*n_words);
  start = (int*)xalloc(sizeof(int)*n_words);
  transitions = (bool**)xalloc(sizeof(bool*)*n_words);
  for (int i=0;i<n_words;i++) {
    words[i] = -1;
    start[i] = -1;
    transitions[i] = (bool*)xalloc(sizeof(bool)*n_words);
    for (int j=0;j<n_words;j++) {
      transitions[i][j] = false;
    }
  }
}

Grammar::~Grammar()
{
  for (int i=0;i<n_words;i++)
    free(transitions[i]);
  free(transitions);
  free(start);
  free(words);
}


}

