/*
 * Copyright 1999,2004-2005 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.catalina.cluster;


/**
 * Cluster Receiver Interface
 * @author Filip Hanik
 * @author Peter Rossbach
 * @version $Revision: 380229 $, $Date: 2006-02-23 16:28:29 -0500 (Thu, 23 Feb 2006) $
 */
public interface ClusterReceiver {
    /**
     * Start message listing
     * @throws java.io.IOException
     */
    public void start() throws java.io.IOException;

    /**
     * Stop message listing 
     */
    public void stop();

    /**
     * set callback.
     *
     * @param cluster The cluster
     */
    public void setCatalinaCluster(CatalinaCluster cluster);
    
    /**
     * get Callback.
     *
     * @return The cluster
     */
    public CatalinaCluster getCatalinaCluster();
    
    /**
     * Send Ack to sender or not.
     *
     * @return The flag value
     */
    public boolean isSendAck();
    
    /**
     * set ack mode
     * @param isSendAck
     */
    public void setSendAck(boolean isSendAck);
    
    public boolean isCompress() ;
    public void setCompress(boolean compress);

    /**
     * get the listing ip interface
     * @return The host
     */
    public String getHost();
    
    
    /**
     * get the listing ip port
     * @return The port
     */
    public int getPort();

}
