/*
 *  Copyright 1999-2004 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/***************************************************************************
 * Description: load balance worker header file                            *
 * Author:      Gal Shachor <shachor@il.ibm.com>                           *
 * Version:     $Revision: 386279 $                                           *
 ***************************************************************************/

#ifndef JK_LB_WORKER_H
#define JK_LB_WORKER_H

#include "jk_logger.h"
#include "jk_service.h"
#include "jk_mt.h"
#include "jk_shm.h"

#ifdef __cplusplus
extern "C"
{
#endif                          /* __cplusplus */

#define JK_LB_WORKER_NAME     ("lb")
#define JK_LB_WORKER_TYPE     (5)
#define JK_LB_DEF_DOMAIN_NAME ("unknown")

#define JK_LB_BYREQUESTS      (0)
#define JK_LB_BYTRAFFIC       (1)
#define JK_LB_BYBUSYNESS      (2)
#define JK_LB_METHOD_REQUESTS ("Request")
#define JK_LB_METHOD_TRAFFIC  ("Traffic")
#define JK_LB_METHOD_BUSYNESS ("Busyness")
#define JK_LB_LOCK_DEFAULT     (0)
#define JK_LB_LOCK_PESSIMISTIC (1)
#define JK_LB_LM_DEFAULT       ("Optimistic")
#define JK_LB_LM_PESSIMISTIC   ("Pessimistic")

#define WAIT_BEFORE_RECOVER   (60)

struct worker_record
{
    jk_worker_t     *w;
    /* Shared memory worker data */
    jk_shm_worker_t  *s;
    /* Current jvmRoute. Can be name or domain */
    const char       *r;
};
typedef struct worker_record worker_record_t;

struct lb_worker
{
    worker_record_t *lb_workers;
    unsigned int num_of_workers;
    int          lbmethod;
    int          lblock;

    jk_pool_t p;
    jk_pool_atom_t buf[TINY_POOL_SIZE];

    jk_worker_t worker;
    JK_CRIT_SEC cs;

    /* Shared memory worker data */
    jk_shm_worker_t  *s;
};
typedef struct lb_worker lb_worker_t;

int JK_METHOD lb_worker_factory(jk_worker_t **w,
                                const char *name, jk_logger_t *l);

#ifdef __cplusplus
}
#endif                          /* __cplusplus */
#endif                          /* JK_LB_WORKER_H */
