/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/


#include "main.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "archive.h"
#include "support.h"
#include "utils.h"

GList *mesgsent_list;
GList *mesgsent2_list;
GList *mesgrecv_list;
GList *mesgrecv2_list;
GList *chat2_list;
GList *arch_list;


void treeview_chat_selection_cb (GtkTreeSelection *selection, gpointer nic)
{
  GtkTreeIter iter;
  GtkTreeView *treeview;
  GtkTreeModel *model;
  GtkWidget *widget2;
  struct arch_mesg *m;
  struct arch_mesg *mesg;
  GList *l = chat2_list;
  gchar *s;
  gboolean jid;

  treeview = (GtkTreeView*)lookup_widget(window_archive, "treeview_chat");
  selection = gtk_tree_view_get_selection(treeview);
  if (! gtk_tree_selection_get_selected (selection, NULL, &iter))
    return;
  model = gtk_tree_view_get_model (treeview);
  gtk_tree_model_get (model, &iter, 2, &jid, -1);

  if(!jid)
  {
    gtk_tree_model_get (model, &iter, 1, &mesg, -1);
    widget2 = lookup_widget(window_archive, "textview_chat");
    textview_clear(widget2);
    while(l)
    {
      m = (struct arch_mesg *) l->data;
      if((!strcmp(mesg->jid, m->jid)) && (!strncmp(mesg->date, m->date, 10)))
      {
        gchar *tag = NULL;

        if(m->from)
          tag="text";
        textview_append(widget2, m->date, 0, "date", NULL);
        textview_append(widget2, " ", 0, tag, NULL);
        s = utf(m->message);
        textview_append(widget2, s, 0, tag, NULL);
        g_free(s);
        textview_append(widget2, "\n", 0, NULL, NULL);
      }
      l = l->next;
    }
  }
}


static
gint jid_added(GList *l, gchar *jid)
{
  while(l)
  {
    if(!strcmp(jid, (gchar *)l->data))
      return 1;
    l=l->next;
  }
  return 0;
}

static
gint date_added(GList *l, gchar *date)
{
  while(l)
  {
    if(!strncmp(date, (gchar *)l->data, 10))
      return 1;
    l=l->next;
  }
  return 0;
}

static
GtkTreeModel *create_model(void)
{
  GtkListStore *store;
  GtkTreeIter iter;
  GList *l;
  struct arch_file *a;

  store = gtk_list_store_new(3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
  l=arch_list;
  while(l)
  {
    a=(struct arch_file*) l->data;
    gtk_list_store_append (store, &iter);
    gtk_list_store_set (store, &iter,
                        0, strrchr(a->filename,'/')+1,
                        1, a->date,
                        2, a->filename,
                        -1);
    l = l->next;
  }


  return GTK_TREE_MODEL (store);
}

static
GtkTreeModel *create_model2 (void)
{
  GtkTreeStore *model;
  GtkTreeIter iter;
  GList *l=chat2_list, *l2=NULL;
  struct arch_mesg *mesg;
  gchar *item;

  model = gtk_tree_store_new (3,G_TYPE_STRING, G_TYPE_POINTER, G_TYPE_BOOLEAN);
  while(l)
  {
    mesg=(struct arch_mesg*)l->data;
    item=g_strdup(mesg->jid);
    if(!jid_added(l2,item))
    {
      l2=g_list_append(l2,(gpointer)item);
      gtk_tree_store_append (model, &iter, NULL);
      gtk_tree_store_set (model, &iter,0,item,1,NULL,2,TRUE,-1);

      //dodaj podrzedne elementy
      {
        GList *l=chat2_list,*l2=NULL;
        struct arch_mesg *m;
        GtkTreeIter child_iter;

        while(l)
        {
          m=(struct arch_mesg*)l->data;
          if(!strcmp(mesg->jid,m->jid))
          {
            item=g_strdup(m->date);
            if(!date_added(l2,item))
            {
              l2=g_list_append(l2,(gpointer)item);
              gtk_tree_store_append (model, &child_iter, &iter);
              gtk_tree_store_set (model, &child_iter,0,item, 1, m,2,FALSE, -1);
            }
            else//FIXME
            g_free(item);
          }
          l=l->next;
        }
        //FIXME sprawdz to!!!
//        l=l2;
//        while(l)
//        {
//          g_free((gchar*)l->data);
//          l=l->next;
//        }
        g_list_free(l2);
      }
    }
    else//FIXME
    g_free(item);
    l=l->next;
  }
//  l=l2;
//  while(l)
//  {
//    g_free((gchar*)l->data);
//    l=l->next;
//  }
  g_list_free(l2);
  return GTK_TREE_MODEL (model);
}

void treeview_chat_refresh()
{
  GtkTreeView *treeview;
  GtkTreeModel *model;

  treeview = (GtkTreeView *) lookup_widget(window_archive, "treeview_chat");
  model = create_model2();
  gtk_tree_view_set_model(treeview, model);
  g_object_unref (G_OBJECT (model));
}

void arch_list_load()
{
  gchar *filename;
  gint i;
  struct arch_file *arch;
  struct stat buf;

  filename = g_strdup_printf("%s/.tleenx/rozmowy.%s", getenv("HOME"),
                           pname);
  if(!file_exists(filename) || stat(filename, &buf))
  {
    g_free(filename);
    return;
  }
  arch = (struct arch_file *) g_malloc(sizeof(*arch));
  arch->filename = filename;
  arch->date = get_localtime(&(buf.st_mtime));
  arch_list = g_list_append(arch_list, arch);
  for(i=1;;i++)
  {
    filename=g_strdup_printf("%s/.tleenx/rozmowy.%s.%d", getenv("HOME"),
                             pname, i);
    if(!file_exists(filename) || stat(filename,&buf))
    {
      g_free(filename);
      break;
    }
    arch = (struct arch_file *) g_malloc(sizeof(*arch));
    arch->filename = filename;
    arch->date = get_localtime(&(buf.st_mtime));
    arch_list = g_list_append(arch_list, arch);
  }
}

void free_arch_mesg(struct arch_mesg *mesg)
{
  g_free(mesg->jid);
  g_free(mesg->date);
  g_free(mesg->message);
  g_free(mesg);
}

static
void free_arch_file(struct arch_file *arch)
{
  g_free(arch->filename);
  g_free(arch->date);
  g_free(arch);
}

static
void arch_list_clear()
{
  GList *l = arch_list;
  struct arch_file *a;

  while(l)
  {
    a = (struct arch_file *) l->data;
    free_arch_file(a);
    l = l->next;
  }
  g_list_free(arch_list);
  arch_list = NULL;
}

void clean_archive()
{
  if(arch_list)
    arch_list_clear();
  if(mesgsent_list)
  {
    mesgsent_list_clear(mesgsent_list);
    mesgsent_list=NULL;
  }
  if(mesgsent2_list)
  {
    g_list_free(mesgsent2_list);
    mesgsent2_list=NULL;
  }
  if(mesgrecv_list)
  {
    mesgsent_list_clear(mesgrecv_list);
    mesgrecv_list=NULL;
  }
  if(mesgrecv2_list)
  {
    g_list_free(mesgrecv2_list);
    mesgrecv2_list=NULL;
  }
  if(chat2_list)
  {
    mesgsent_list_clear(chat2_list);
    chat2_list=NULL;
  }
}

void mesgsent_list_clear(GList *list)
{
  GList *l=list;
  struct arch_mesg *mesg;

  while(l)
  {
    mesg=(struct arch_mesg*)l->data;
    free_arch_mesg(mesg);
    l=l->next;
  }
  g_list_free(list);
}

static
gchar *read_message(FILE *f)
{
  gchar c, *s=NULL, *message;
  gint i=0,l;

  l=30;
  s=(gchar*)g_malloc(l*sizeof(gchar));
  while(1)
  {
    fscanf(f,"%c",&c);
    if(feof(f))
      break;
    if(c != '#')
      break;
    for(;1;i++)
    {
      fread(&c,1,1,f);
      if(i==l)
        s=(gchar *)g_realloc(s,(l+=30)*sizeof(gchar));
      s[i]=c;
      if(c == '\n')
        break;
    }
  }
  s[i]='\0';
  message=g_strdup(s);
  if(s)
    g_free(s);
  return message;
}

static
void read_mesg(FILE *f, struct arch_mesg *mesg)
{
  gchar jid[40];
  gint D,M,Y,h,m,s;
  gchar sD[3],sM[3],sh[3],sm[3],ss[3];

  fscanf(f,"%s\n",jid);
  fscanf(f,"%d %d %d\n",&D,&M,&Y);
  fscanf(f,"%d %d %d\n",&h,&m,&s);
  if(D<10)
    sprintf(sD,"0%d",D);
  else
    sprintf(sD,"%d",D);
  if(M<10)
    sprintf(sM,"0%d",M);
  else
    sprintf(sM,"%d",M);
  if(h<10)
    sprintf(sh,"0%d",h);
  else
    sprintf(sh,"%d",h);
  if(m<10)
    sprintf(sm,"0%d",m);
  else
    sprintf(sm,"%d",m);
  if(s<10)
    sprintf(ss,"0%d",s);
  else
    sprintf(ss,"%d",s);
  mesg->jid=g_strdup(jid);
  mesg->date=g_strdup_printf("%d.%2s.%2s %2s:%2s:%2s",Y,sM,sD,sh,sm,ss);
  mesg->message = read_message(f);
}

int archive_read_mesgsent()
{
  struct arch_mesg *mesg;
  FILE *f;
  gchar *filename,c;

  filename=g_strdup_printf("%s/.tleenx/wiadomosci.%s",getenv("HOME"), pname);
  f=fopen(filename, "r");
  g_free(filename);
  if(!f)
  {
//    g_print("bd: nie mona utworzy pliku\n");
//    gtk_exit(1);
    return 2;
  }
  while(!feof(f))
  {
    fscanf(f,"%c\n",&c);
    mesg=(struct arch_mesg *)g_malloc(sizeof(*mesg));
    read_mesg(f,mesg);
    if(c == '>')
      mesgsent_list=g_list_append(mesgsent_list,(gpointer)mesg);
    else
      mesgrecv_list=g_list_append(mesgrecv_list,(gpointer)mesg);
//      skip_mesg(f);
    if(feof(f))
      break;
    fseek(f,-1,SEEK_CUR);
  }
  fclose(f);
  return 0;
}

int archive_read_chat(const gchar *filename)
{
  struct arch_mesg *mesg;
  FILE *f;
  gchar c;

  f=fopen(filename, "r");
  if(!f)
  {
//    g_print("bd: nie mona utworzy pliku\n");
//    gtk_exit(1);
    return 2;
  }
  if(chat2_list)
  {
    mesgsent_list_clear(chat2_list);
    chat2_list=NULL;
  }
  while(!feof(f))
  {
    fscanf(f,"%c\n",&c);
    mesg=(struct arch_mesg *)g_malloc(sizeof(*mesg));
    read_mesg(f,mesg);
    if(c == '>')
      mesg->from=0;
    else
      mesg->from=1;
    chat2_list=g_list_append(chat2_list,(gpointer)mesg);
    //      skip_mesg(f);
    if(feof(f))
      break;
    fseek(f,-1,SEEK_CUR);
  }
  fclose(f);
  return 0;
}

static
GtkTreeModel *treeview_sent_create_model(GList *l)
{
  GtkTreeStore *model;
  GtkTreeIter iter;
  struct arch_mesg *a;

  model = gtk_tree_store_new(3, G_TYPE_POINTER, G_TYPE_STRING, G_TYPE_STRING);
  while(l)
  {
    a = (struct arch_mesg *) l->data;
    gtk_tree_store_append (model, &iter, NULL);
    gtk_tree_store_set (model, &iter,
                        0, a,
                        1, a->jid,
                        2, a->date,
                        -1);
    l = l->next;
  }

  return GTK_TREE_MODEL (model);
}

static
void treeview_sent_selection_cb (GtkTreeSelection *selection,
                                 gpointer list)
{
  GtkTreeIter iter;
  GtkTreeModel *model;
  GtkWidget *treeview, *textview;
  struct arch_mesg *mesg;
  gchar *s;
  GList *l = (GList *)list;

  if((l == mesgsent_list) || (l == mesgsent2_list))
  {
    treeview = lookup_widget(window_archive, "treeview_sent");
    textview = lookup_widget(window_archive, "textview_sent");
  }
  else
  {
    treeview = lookup_widget(window_archive, "treeview_received");
    textview = lookup_widget(window_archive, "textview_received");
  }

  if (! gtk_tree_selection_get_selected (selection, NULL, &iter))
    return;
  model = gtk_tree_view_get_model (GTK_TREE_VIEW(treeview));
  gtk_tree_model_get (model, &iter, 0, &mesg, -1);

  textview_clear(textview);
  s = utf(mesg->message);
  textview_append(textview, s, 0, NULL, NULL);
  g_free(s);
}

static
void refresh_treeview_sent(GtkWidget *treeview, GList *l)
{
  GtkTreeSelection *selection;
  GtkTreeModel *model;

  model = treeview_sent_create_model(l);
  gtk_tree_view_set_model(GTK_TREE_VIEW(treeview), model);
  g_object_unref (G_OBJECT (model));
  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview));
  g_signal_connect (selection, "changed",
                    G_CALLBACK (treeview_sent_selection_cb), l);
}

void treeview_sent_sort_by_name()
{
  GtkWidget *treeview;

  treeview = lookup_widget(window_archive, "treeview_sent");
  refresh_treeview_sent(treeview, mesgsent_list);
}

void treeview_sent_sort_by_date()
{
  GtkWidget *treeview;

  treeview = lookup_widget(window_archive, "treeview_sent");
  refresh_treeview_sent(treeview, mesgsent2_list);
}

void treeview_received_sort_by_name()
{
  GtkWidget *treeview;

  treeview = lookup_widget(window_archive, "treeview_received");
  refresh_treeview_sent(treeview, mesgrecv_list);
}

void treeview_received_sort_by_date()
{
  GtkWidget *treeview;

  treeview = lookup_widget(window_archive, "treeview_received");
  refresh_treeview_sent(treeview, mesgrecv2_list);
}

void treeview_archives_refresh()
{
  GtkTreeView *treeview;
  GtkTreeModel *model;

  treeview = (GtkTreeView *) lookup_widget(window_archive,"treeview_archives");
  model = create_model();
  gtk_tree_view_set_model(treeview, model);
  g_object_unref (G_OBJECT (model));
}

static
gint compare_func(gconstpointer d1, gconstpointer d2)
{
  struct arch_mesg *mesg1,*mesg2;

  mesg1=(struct arch_mesg*)d1;
  mesg2=(struct arch_mesg*)d2;
  return strcmp(mesg1->jid,mesg2->jid);
}

static
void mesglist_sort(GList *l, GList **l2)
{
  struct arch_mesg *mesg;

  while(l)
  {
    if(!(l->next))
      break;
    l=l->next;
  }
  while(l)
  {
    mesg=(struct arch_mesg*)l->data;
    *l2=g_list_insert_sorted(*l2,(gpointer)mesg,compare_func);
    l=l->prev;
  }
}

void mesgsent_sort_by_date()
{
  if(!mesgsent2_list)
    mesglist_sort(mesgsent_list, &mesgsent2_list);
}

void mesgrecv_sort_by_date()
{
  if(!mesgrecv2_list)
    mesglist_sort(mesgrecv_list, &mesgrecv2_list);
}

static
void mesg_delete(GList **list, gchar *jid, gchar *date)
{
  struct arch_mesg *mesg;
  GList *l;

  l = *list;
  while(l)
  {
    mesg = (struct arch_mesg*) l->data;
    if(!strcmp(mesg->jid, jid) && !strcmp(mesg->date, date))
    {
//      free_arch_mesg(mesg);
//      *list = g_list_remove(*list, l->data);
      g_print("link deleted\n");
      if(*list)
        g_print("list ok\n");
      else
        g_print("list NULL\n");
      break;
    }
    l=l->next;
  }
}

void mesgsent_delete(gchar *jid, gchar *date)
{
  mesg_delete(&mesgsent_list, jid, date);
//  g_list_free(mesgsent2_list);
//  mesgsent2_list=NULL;
  mesgsent_sort_by_date();
}

void mesgrecv_delete(gchar *jid, gchar *date)
{
  mesg_delete(&mesgrecv_list, jid, date);
  g_list_free(mesgrecv2_list);
  mesgrecv2_list=NULL;
}
