/*
** iksemel (XML Parser for Jabber)
** Copyright (C) 2000-2001 Gurer Ozen <palpa@jabber.org>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of GNU Lesser General Public License.
**
** parser management
*/

#include "common.h"

#ifdef USE_EXPAT
#include <expat.h>
#define IKSEMEL_EXPAT
#endif

#include "iksemel.h"


static void dom_tstart(iksparser *prs, char *tag, char **atts);
static void dom_tend(iksparser *prs, char *tag);
static void jab_tstart(iksparser *prs, char *tag, char **atts);
static void jab_tend(iksparser *prs, char *tag);
static void hook_cdata(iksparser *prs, char *data, int len);

#define DEFAULT_POOL_SIZE 8192

iksparser *iks_sax_new(void *udata, iksTagStart *ts, iksTagEnd *te, iksCharData *cd)
{
	iksparser *prs;
        ikspool *p;

        p = iks_pool_new(DEFAULT_POOL_SIZE);
        if (!p)
          return NULL;
	prs = iks_pool_alloc(p, sizeof(iksparser));
	if(!prs) return(NULL);
	memset(prs, 0, sizeof(iksparser));
        prs->p = p;
        iks_pool_set_owner(p, prs);

#ifdef USE_EXPAT
	prs->expat = XML_ParserCreate(NULL);
	if(!prs->expat)
	{
		iks_pool_delete(prs->p);
		return NULL;
	}
	XML_SetUserData(prs->expat, (void *)prs);
	XML_SetElementHandler(prs->expat, (XML_StartElementHandler)ts, (XML_EndElementHandler)te);
	XML_SetCharacterDataHandler(prs->expat, (XML_CharacterDataHandler)cd);
#endif
	prs->udata = udata;
	prs->udata2 = udata;
	prs->tagStart = ts;
	prs->tagEnd = te;
	prs->charData = cd;

	return prs;
}


iksparser *iks_dom_new(iks **iksptr)
{
	iksparser *prs;

	prs = iks_sax_new(NULL, (iksTagStart *)dom_tstart, (iksTagEnd *)dom_tend, (iksCharData *)hook_cdata);
	if(!prs) return(NULL);
	prs->udata = prs;
	prs->iksptr = iksptr;
	return prs;
}


iksparser *iks_jabber_new(void *udata, iksJPak *jp)
{
	iksparser *prs;

	prs = iks_sax_new(NULL, (iksTagStart *)jab_tstart, (iksTagEnd *)jab_tend, (iksCharData *)hook_cdata);
	if(!prs) return(NULL);
	prs->udata = prs;
	prs->udata2 = udata;
	prs->jPak = jp;
	return prs;
}


void iks_set_logging(iksparser *prs, iksJLog *jl)
{
	prs->jLog = jl;
}


#ifdef USE_EXPAT
int iks_parse(iksparser *prs, char *data, int len, int finish)
{
	if(XML_Parse(prs->expat, data, len, 0))
		return IKS_RET_OK;

	return IKS_RET_BADXML;
}
#endif


void iks_parser_delete(iksparser *prs)
{
#ifdef USE_EXPAT
	XML_ParserFree(prs->expat);
#endif
	if(prs->conn) iks_disconnect(prs);

        /* XXX: this should always be true; we don't have a pool constructor. */

        if (iks_pool_owner(prs->p) == prs)
          iks_pool_delete(prs->p);
}


/*****  Internal Hooks  *****/

static void insert_attribs(iksparser* p, iks *x, char **atts)
{
	int i=0;

	if(!x || !atts) return;
	while(atts[i])
	{
		iks_insert_attrib(x, atts[i], atts[i+1]);
		i += 2;
	}
}


static void dom_tstart(iksparser *prs, char *tag, char **atts)
{
	iks *x;

	/* FIX ME: handle PIs in parser */
	if(tag[0] == '?') return;

	if(prs->current)
		x = iks_insert(prs->current, tag);
	else
		x = iks_new(tag);
	insert_attribs(prs, x, atts);
	prs->current = x;
}


static void jab_tstart(iksparser *prs, char *tag, char **atts)
{
	iks *x;

	/* FIX ME: handle PIs in parser */
	if(tag[0] == '?') return;

	if(prs->current)
	{
		x = iks_insert(prs->current, tag);
		insert_attribs(prs, x, atts);
		prs->current = x;
	}
	else
	{
		x = iks_new_pool(prs->p, tag);
		insert_attribs(prs, x, atts);
		if(strcmp(tag, "stream:stream") == 0)
			CALL_JPAK(iks_packet(x));
		else
			prs->current = x;
	}
}


static void dom_tend(iksparser *prs, char *tag)
{
	iks *x;

	x = iks_parent(prs->current);
	if(x)
		prs->current = x;
	else
		*(prs->iksptr) = prs->current;
}


static void jab_tend(iksparser *prs, char *tag)
{
	iks *par;

	if(!prs->current)
	{
		/* got </stream:stream> */
		CALL_JPAK(NULL);
		return;
	}

	par = iks_parent(prs->current);

	if(par)
          {
            prs->current = par;
          }
        else
          {
            /* top-level stuff goes to the packet handler. */

            ikspak *pak = iks_packet(prs->current);

            CALL_JPAK(pak);

            /* We allocate them, thus, we should delete them. */

            iks_packet_delete(pak);
            iks_delete(prs->current);
            prs->current = NULL;
          }
}


static void hook_cdata(iksparser *prs, char *data, int len)
{
	if(prs->current)
		iks_insert_cdata(prs->current, data, len);
}
