/****************************************************************************
    Copyright (C) 1987-2004 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
****************************************************************************/
/*
    Generic functions for gates.
*/
#ifndef __generic_h
#define __generic_h

const char *seekOption(const char*,const char**,int);

GCElement *Generic_Make(EditState **es,GModuleDef *env,int GType,
			int x,int y,int r,const char *Name,int noWires,const char**,int);
void Generic_Init(GCElement*);
void Generic_Delete(GCElement*,GModuleDef*,int);
void Generic_GetExtents(GCElement *g,int *minx,int *miny,int *maxx,int *maxy,int *bd);
int Generic_HitDistance(GCElement*g,int,int);
void Generic_Draw(GCElement *g,int md);
void Generic_Move(GCElement*,int,int);
GCElement *Generic_Replicate(GModuleDef*,GCElement*,int,int,unsigned);
void Generic_AddInput(EditState*,GCElement*);
void Generic_AddOutput(EditState*,GCElement*);
void Generic_PSWrite(FILE*,GModLayout*,GCElement*);
void Generic_EditProps(GCElement*,int isStore);
void Generic_VerSave(FILE*,GCElement*);

void Generic_DrawGateLabel(FILE *f,GCElement *g,const char *text);
void Generic_PSLabels(FILE *f,GCElement *g);

void Err_AddInput(EditState*,GCElement*);
void Err_AddOutput(EditState*,GCElement*);
void Err_AddInOut(EditState*,GCElement*);
void Err_ChangePin(EditState*,GCElement*);

GCElement *Nop_Replicate(EditState *es,GCElement *g,int x,int y,unsigned flags);
void Nop_SimStateFunc(EditState*,GCElement*,const char*);
void Nop_SimHitFunc(EditState*,GCElement*);
int Nop_VerSave(FILE*,GCElement*);

GCElement *InOut_Make(EditState **es,GModuleDef *env,int GType,
		      int x,int y,int r,const char *Name,int noWire,const char**,int);
void InOut_Draw(GCElement*,int);
void InOut_VerSave(FILE *f,GCElement *g);
void InOut_PSWrite(FILE *f,GModLayout *L,GCElement *g);

#endif

