#   Copyright (C) 1987-2004 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Tue Mar  9 12:59:58 2004
#

#Some common paper sizes (in mm):
#Chu ban			220 x 288
#Ko bosho	    		330 x 470
#Mino, Hosokawa, Hodomura	330 x 850
#Mino ban, Hodomura ban 	610 x 860
#Naka bosho 			364 x 500
#O bosho 			394 x 530
#O biro bosho 			440 x 576
#Takenaga bosho 		515 x 757
#Fotopapier
#Mutsugiri 			203 x 254
#Yatsugiri (hele plaat) 	165 x 216
#Yotsugiri 			254 x 305
#Diversen
#Briefkaart (officieel) 	100 x 148
#Kiku 4 (boeken) 		227 x 306
#Kiku 5 (boeken) 		151 x 227
#Meishi (visitekaartje) 	55 x 91


set pd_isfile 1
set pd_file ""
set pd_select all
set pd_oldSelect all
set pd_ok 0
set pd_selectList {}
set pd_mergeSmall 1
set pd_epsf 0
set pd_title ""
set pd_print $tkg_printCommand
if { $lang == "en" }  {
  set pd_paper $tkg_printPgSize
} else {
  set pd_paper $tkg_printPgSizeA4
}
set pd_orient $tkg_printPgOrient
set pd_style $tkg_printStyle
set pd_index $tkg_printIndex
set pd_graph $tkg_printGraph
set pd_duplexMode $tkg_printDuplex
set pd_inclib 0
set pd_encoding Latin1

set prs_start 0
set prs_end 0
set prs_isFull 0
set prs_range {0 0 0}
set prs_scale 1

set pd_filter ".ps"
set pd_filetypes {
    {{PostScript}	{.ps}}
    {{All Files}	*}
}

array set pd_paperSizes {
    0 "Letter (8 1/2 x 11 in.)"
    1 "Legal (8 1/2 x 14 in.)"
    2 "Tabloid (11 x 17 in.)"
    3 "Executive (7 1/2 x 10 in.)"
    4 "A4 (210 x 297 mm)"
    5 "A3 (297 x 420 mm)"
    6 "A2 (420 x 594 mm)"
    7 "A1 (594 x 841 mm)"
    8 "B5 (176 x 250 mm)"
    9 "B4 (250 x 353 mm)"
    10 "B3 (353 x 500 mm)"
    11 "B2 (500 x 707 mm)"
    12 "SRA2 (450 x 640 mm)"
    13 "RA2 (430 x 610 mm)"
    14 "yatsugiri (6.5 x 8.5 in)"
    15 "mutsugiri (8 x 10 in)"
    16 "yotsugiri (10 x 12 in)"
}

proc tkg_retrSelMods {w} {
  global pd_select pd_selectList

  set pd_selectList {}
  if { $pd_select == "sel" } {
    foreach m [$w.mods.lb curselection] {
      lappend pd_selectList [$w.mods.lb get $m]
    }
  }
}

proc tkg_outSelect {lpr file} {
  global pd_isfile
  if { $pd_isfile } {
    $lpr.l configure -foreground dimgray
    $lpr.e configure -foreground dimgray -state disabled
    $file.l configure -foreground black
    $file.e configure -foreground black -state normal
    $file.b configure -foreground black -state normal
    $file.epsf configure -foreground black -state normal
    focus $file.e
  } else {
    $lpr.l configure -foreground black
    $lpr.e configure -foreground black -state normal
    $file.l configure -foreground dimgray
    $file.e configure -foreground dimgray -state disabled
    $file.b configure -foreground dimgray -state disabled
    $file.epsf configure -foreground dimgray -state disabled
    focus $lpr.e
  }
  tkg_prntEPSF
}

proc tkg_prntEPSF {} {
  global pd_epsf pd_isfile pd_select pd_oldSelect


  catch {
    set w1 .prntdlg.right.mod
    set w2 .prntdlg.right.style

    if { $pd_epsf && $pd_isfile } {
	$w1.sel.all configure -foreground dimgray -state disabled
	$w1.sel.cur configure -foreground dimgray -state disabled
	$w1.sel.use configure -foreground dimgray -state disabled
	$w1.sel.sel configure -foreground dimgray -state disabled
	$w1.mods.lb configure -foreground dimgray -selectforeground dimgray
	$w1.lib     configure -foreground dimgray -state disabled
	$w2.idx     configure -foreground dimgray -state disabled
	$w2.graph   configure -foreground dimgray -state disabled
	$w2.mrgsml  configure -foreground dimgray -state disabled
	$w2.part.scale   configure -foreground dimgray -state disabled
	$w2.part.multi   configure -foreground dimgray -state disabled
	$w2.l   configure -foreground dimgray
#	$w1.l   configure -foreground dimgray

	set pd_oldSelect $pd_select
	set pd_select cur
    } {
	$w1.sel.all configure -foreground black -state normal
	$w1.sel.cur configure -foreground black -state normal
	$w1.sel.use configure -foreground black -state normal
	$w1.sel.sel configure -foreground black -state normal
	$w1.mods.lb configure -foreground black -selectforeground black
	$w1.lib     configure -foreground black -state normal
	$w2.idx     configure -foreground black -state normal
	$w2.graph   configure -foreground black -state normal
	$w2.mrgsml  configure -foreground black -state normal
	$w2.part.scale   configure -foreground black -state normal
	$w2.part.multi   configure -foreground black -state normal
	$w2.l   configure -foreground black
#	$w1.l   configure -foreground black

	set pd_select $pd_oldSelect
    }
  }
}

#
# Called when the module select mode is pressed
#
proc tkg_prntModuleMode {w} {
  global pd_select
   
  if { $pd_select == "sel" } {
    $w.mods.lb configure -foreground black -selectforeground black
  } else {
    $w.mods.lb configure -foreground dimgray -selectforeground dimgray
  }
}

proc tkg_paperSelLabel {w n} {
  global pd_paper
  set pd_paper $n
#  set label [$w.size.mb.menu entrycget $n -label]
#  $w.size.mb configure -text $label

  tkg_prntConfigPC
}

proc tkg_setPaperSize {w psize} {
  global pd_paperSizes

  set n 0
  for {set id [array startsearch pd_paperSizes]} {[array anymore pd_paperSizes $id]} {} {
    set k [array nextelement pd_paperSizes $id]
    set v $pd_paperSizes($k)
    if { $v == $psize } {
      set n $k
      break
    }
  }
  array donesearch pd_paperSizes $id

  tkg_paperSelLabel $w $n
}

proc tkg_prntOutSel {w lpr file} {
  frame $w -relief groove -bd 2
  frame $w.pad
  pack $w.pad -pady 3
#  label $w.label  -text "[m print.outto]:"
  radiobutton $w.print -text [m print.printer] -value 0 -variable pd_isfile -command "tkg_outSelect $lpr $file"
  radiobutton $w.file -text [m print.file] -value 1 -variable pd_isfile -command "tkg_outSelect $lpr $file"
#  pack $w.label 
  pack $w.print $w.file -side left -padx 5 -pady 5
}

proc tkg_prntLprSel {w r} {
  frame $w -relief groove -bd 2
  label $w.l  -text "[m print.prcmd]:"
  entry $w.e -textvariable pd_print
  pack $w.l $w.e -side left -padx 5 -pady 5
}

proc tkg_prntFileSel {w} {

  frame $w -relief groove -bd 2
  frame $w.pad
  pack $w.pad -pady 5

  label $w.l -text "[m print.filename]:"
  entry $w.e -textvariable pd_file -width 30
  button $w.b -text [m b.browse] -command {
    global pd_filter pd_filetypes pd_file
    set file [tk_getSaveFile -defaultextension $pd_filter -filetypes $pd_filetypes -parent .prntdlg]
    if { $file != "" } { 
      set pd_file $file
      .prntdlg.left.file.e icursor end
      .prntdlg.left.file.e xview end
    }
  }

  checkbutton $w.epsf -text [m print.epssave] -variable pd_epsf -command tkg_prntEPSF

  pack $w.epsf -side bottom -pady 5 -padx 5 -anchor w
  pack $w.l -pady 3 -padx 5 -anchor w
  pack $w.e -side left -padx 5 -fill x
  pack $w.b -side left -padx 5
}

proc tkg_prntTitleSel {w} {
  frame $w -relief groove -bd 2
  label $w.l  -text "[m print.doctit]:"
  entry $w.e -textvariable pd_title -width 44
  pack $w.l $w.e -anchor w -padx 5 -pady 5
}

proc tkg_prntModSel {w} {
  frame $w -relief groove -bd 2
  frame $w.pad
  pack $w.pad -pady 3

#  label $w.l  -text "[m print.prmod]:"

  frame $w.sel

  radiobutton $w.sel.all -text [m print.all] -value all -variable pd_select -command "tkg_prntModuleMode $w"
  radiobutton $w.sel.cur -text [m print.cur] -value cur -variable pd_select -command  "tkg_prntModuleMode $w"
  radiobutton $w.sel.use -text [m print.use] -value use -variable pd_select -command  "tkg_prntModuleMode $w"
  radiobutton $w.sel.sel -text [m print.sel] -value sel -variable pd_select -command "tkg_prntModuleMode $w"
  pack $w.sel.all  $w.sel.cur  $w.sel.use  $w.sel.sel -side left

  checkbutton $w.lib -text [m print.inclib] -variable pd_inclib

  frame $w.mods
  listbox $w.mods.lb -height 5 -yscrollcommand "$w.mods.vb set" -selectmode extended
  scrollbar $w.mods.vb -command "$w.mods.lb yview"
  pack $w.mods.lb $w.mods.vb -side left -fill y

  set n [.sbar.blklst.f.list size]
  for {set i 0} {$i < $n} {incr i} {
    set e [.sbar.blklst.f.list get $i]
    $w.mods.lb insert $i $e
  }

#  pack $w.l -padx 5 -pady 5 -anchor w
  pack $w.sel  -padx 5 -pady 5 -anchor w
  pack $w.mods -padx 5 -pady 5
  pack $w.lib  -padx 5 -pady 5 -anchor w

  tkg_prntModuleMode $w

  helpon $w.sel.all [m ho.print.selall]
  helpon $w.sel.cur [m ho.print.selcur]
  helpon $w.sel.use [m ho.print.seluse]
  helpon $w.sel.sel [m ho.print.selsel]
#  helpon $w.l [m ho.print.modlist]
}

#
# Dialog element for selecting page size.
#
proc tkg_prntPaperSel {w r} {
  global pd_paper pd_paperSizes

  frame $w -relief $r -bd 2
  frame $w.pad
  pack $w.pad -pady 3

  frame $w.size

  label $w.size.l -text "[m print.papsz]:"

  set curSize $pd_paperSizes($pd_paper)
  set N [array size pd_paperSizes]

#  menubutton $w.size.mb -menu $w.size.mb.menu -text $curSize -indicatoron 1 -relief raised -bd 2
#  menu $w.size.mb.menu -tearoff 0

#  for {set i 0} {$i < $N} {incr i} {
#    $w.size.mb.menu add command -label $pd_paperSizes($i) -command "tkg_paperSelLabel $w $i"
#  }
  Dropbox::new $w.size.mb -value $curSize -command tkg_setPaperSize -width 25
  for {set i 0} {$i < $N} {incr i} {
    Dropbox::itemadd $w.size.mb [list "$pd_paperSizes($i)"]
  }



  pack $w.size.l $w.size.mb -side left -padx 5 -pady 5 -anchor w

  frame $w.o
  label $w.o.l -text "[m print.orient]: "
  radiobutton $w.o.p -text [m print.portrait] -variable pd_orient -value portrait -command tkg_prntConfigPC
  radiobutton $w.o.ls -text [m print.landscape] -variable pd_orient -value landscape -command tkg_prntConfigPC
  pack $w.o.l $w.o.p $w.o.ls  -side left -padx 5 -pady 5 -anchor w

  frame $w.dup
  checkbutton $w.dup.b -text [m print.2side] -variable pd_duplexMode
  pack  $w.dup.b -padx 5 -pady 5

  pack $w.size -anchor w -ipady 10
  pack $w.o -anchor w
  pack $w.dup -anchor w

  tkg_paperSelLabel $w $pd_paper
}

proc tkg_prntStyleSel {w r} {
  frame $w -relief $r -bd 2

#  label $w.l -text 

  frame $w.part
  radiobutton $w.part.scale -text [m print.scale] -variable pd_style -value fit
  radiobutton $w.part.multi -text [m print.partition] -variable pd_style -value part
  pack $w.part.scale $w.part.multi -anchor w

  checkbutton $w.idx -text [m print.incidx] -variable pd_index
  checkbutton $w.graph -text [m print.incgraph] -variable pd_graph
  checkbutton $w.mrgsml -text [m print.4up] -variable pd_mergeSmall

  frame $w.sp1
  frame $w.sp2

#  pack $w.l -anchor w -padx 5 
  pack $w.sp1 -anchor w -padx 5 -pady 5
  pack $w.part -anchor w -padx 5 
  pack $w.sp2 -anchor w -padx 5  -pady 10
  pack $w.idx -anchor w -padx 5 
  pack $w.graph -anchor w -padx 5 
  pack $w.mrgsml -anchor w -padx 5 
}

#
# Print a file with default values
#
proc tkg_printWithDefaults {isFile name} {
  global pd_isfile pd_print pd_file pd_title pd_ok
  global tkg_currentFile tkg_displayFile
  global pd_file pd_paper pd_paperSizes pd_orient pd_style pd_select pd_selectList
  global pd_epsf pd_index pd_title pd_mergeSmall pd_duplexMode pd_inclib pd_graph pd_encoding


  set pd_title $tkg_displayFile
  set p [string last "/" $pd_file]
  if { $p >= 0 } { set pd_file [string range $pd_file [expr $p + 1] end]}

  scan $pd_paperSizes($pd_paper) "%s" curSize

  if {$isFile} {
    gat_print -file $name -paper $curSize -orient $pd_orient -style $pd_style -select $pd_select -modlist $pd_selectList -epsf $pd_epsf -index $pd_index -title $pd_title -merge $pd_mergeSmall -duplex $pd_duplexMode -graph $pd_graph -inclib $pd_inclib -encoding $pd_encoding
  } { 
    gat_print -printer $name -paper $curSize -orient $pd_orient -style $pd_style -select $pd_select -modlist $pd_selectList -epsf $pd_epsf -index $pd_index -title $pd_title -merge $pd_mergeSmall -duplex $pd_duplexMode -graph $pd_graph -inclib $pd_inclib -encoding $pd_encoding
  }
}

#
# Dialog box for printing circuits

proc tkg_printDlg {} {
  global pd_isfile pd_print pd_file pd_title pd_ok
  global tkg_currentFile tkg_displayFile

  set w .prntdlg

  if { [catch {toplevel $w}] } {
    return
  }

  wm transient $w .

  set pd_title $tkg_displayFile
  set pd_file  [replaceExtension $tkg_currentFile ".ps"]
  set p [string last "/" $pd_file]
  if { $p >= 0 } { set pd_file [string range $pd_file [expr $p + 1] end]}

  set pd_ok 0

  wm resizable $w 0 0
  wm title $w "TKGate: Print"
  wm geometry $w [offsetgeometry . 50 50 ]

  frame $w.left
  frame $w.right

  tkg_prntOutSel $w.left.out $w.left.lpr $w.left.file
  tkg_prntLprSel $w.left.lpr groove
  tkg_prntFileSel $w.left.file
  tkg_prntPaperSel $w.left.paper groove
  tkg_prntTitleSel $w.left.title
  tkg_prntStyleSel $w.right.style groove
  tkg_prntModSel $w.right.mod
  okcancel $w.okc "global pd_ok; set pd_ok 1; tkg_retrSelMods $w.right.mod; destroy .prntdlg" { destroy .prntdlg }

  bind $w <Return> "global pd_ok; set pd_ok 1; tkg_retrSelMods $w.right.mod; destroy .prntdlg"

  pack $w.okc -fill both -side bottom
  pack $w.left $w.right -side left -fill both -padx 3 -pady 5

  pack $w.left.out -padx 5 -pady 5 -fill both
  pack $w.left.lpr -padx 5 -pady 5 -fill both
  pack $w.left.file -padx 5 -pady 5 -fill both
  pack $w.left.paper -padx 5 -pady 5 -fill both -expand 1
  pack $w.left.title -padx 5 -pady 5 -fill both
  pack $w.right.style -padx 5 -pady 5 -fill both
  pack $w.right.mod -padx 5 -pady 5 -fill both -expand 1

  tkg_outSelect $w.left.lpr $w.left.file

  grab set $w
  tkwait window $w
  grab release $w

  if {$pd_ok} {
    global pd_file pd_paper pd_paperSizes pd_orient pd_style pd_select pd_selectList
    global pd_epsf pd_index pd_title pd_mergeSmall pd_duplexMode pd_inclib pd_graph pd_encoding

    scan $pd_paperSizes($pd_paper) "%s" curSize

    if {$pd_isfile} {
      gat_print -file $pd_file -paper $curSize -orient $pd_orient -style $pd_style -select $pd_select -modlist $pd_selectList -epsf $pd_epsf -index $pd_index -title $pd_title -merge $pd_mergeSmall -duplex $pd_duplexMode -graph $pd_graph -inclib $pd_inclib -encoding $pd_encoding
    } { 
      gat_print -printer $pd_print -paper $curSize -orient $pd_orient -style $pd_style -select $pd_select -modlist $pd_selectList -epsf $pd_epsf -index $pd_index -title $pd_title -merge $pd_mergeSmall -duplex $pd_duplexMode -graph $pd_graph -inclib $pd_inclib -encoding $pd_encoding
    }
  }
}

#############################################################################

proc tkg_prntRangeSelSetState {w} {
  global prs_isFull

  if { $prs_isFull } {
    $w.g.sl configure -foreground dimgray
    $w.g.el configure -foreground dimgray
    $w.g.se configure -foreground dimgray -state disabled
    $w.g.ee configure -foreground dimgray -state disabled
  } {
    $w.g.sl configure -foreground black
    $w.g.el configure -foreground black
    $w.g.se configure -foreground black -state normal
    $w.g.ee configure -foreground black -state normal
  }

  tkg_prntConfigPC
}

proc tkg_prntRangeSel {w} {
  global prs_start prs_end prs_range prs_isFull

  frame $w -relief raised -bd 2
  label $w.l  -text [m print.range]

  set prs_range [gat_getTraceData]

  set prs_start [lindex $prs_range 0]
  set prs_end [lindex $prs_range 1]
  set prs_traceEnd [lindex $prs_range 2]

  if { $prs_start == 0 && $prs_end == $prs_traceEnd} {
    set prs_isFull 1
  } else {
    set prs_isFull 0
  }

  radiobutton $w.full -text [m print.fulltr] -variable prs_isFull -value 1 -command "tkg_prntRangeSelSetState $w"
  radiobutton $w.part -text [m print.parttr] -variable prs_isFull -value 0 -command "tkg_prntRangeSelSetState $w"

  frame $w.g
  label $w.g.sl -text [m print.start]
  label $w.g.el -text [m print.end]
  entry $w.g.se -textvariable prs_start
  entry $w.g.ee -textvariable prs_end
  grid $w.g.sl -row 0 -column 0 -sticky e -padx 5 -pady 5
  grid $w.g.se -row 0 -column 1 -padx 5 -pady 5
  grid $w.g.el -row 1 -column 0 -sticky e -padx 5 -pady 5
  grid $w.g.ee -row 1 -column 1 -padx 5 -pady 5

  pack $w.l -padx 5 -pady 5 -anchor w
  pack $w.full -padx 5 -pady 2 -anchor w
  pack $w.part -padx 5 -pady 2 -anchor w
  pack $w.g -padx 5 -pady 5

  tkg_prntRangeSelSetState $w

  helpon $w.full [m ho.print.fulltrace]
  helpon $w.part [m ho.print.parttrace]
  helpon $w.g.sl [m ho.print.parttracestart]
  helpon $w.g.el [m ho.print.parttraceend]

  pack $w -fill x
}

proc tkg_prntConfigPC args {
  global prs_start prs_end prs_range prs_isFull prs_numepochs prs_scale pd_paper
  global page_estimate pd_orient

  if { $prs_isFull } {
    set start 0
    set end [lindex $prs_range 2]
  } {
    set start $prs_start
    set end $prs_end
  }

  set page_estimate [gat_tracePageEst -orient $pd_orient -start $start -end $end -scale $prs_scale -paper $pd_paper]
}

proc tkg_prntRangeScale {w} {
  global page_estimate

  set sc_max 1000
  set sc_min 10
  set sc_default 70

  frame $w -relief raised -bd 2

  scale $w.s -label [m print.epcm] -from $sc_max -to $sc_min -length 200 -orient horizontal -variable prs_scale -command tkg_prntConfigPC
  $w.s set $sc_default

  label $w.l -text "[m print.estpg]: "

  set page_estimate 0
  label $w.pc -textvariable page_estimate

  pack $w.s -padx 5 -pady 5
  pack $w.l $w.pc -side left -padx 5 -pady 5

  pack $w -fill x
}


#
# Dialog box for scope traces
#
proc tkg_scopePrintDlg {} {
  global pd_isfile pd_print pd_file pd_title pd_ok
  global tkg_currentFile tkg_displayFile
  global prs_start prs_end prs_scale

  if { ![tkg_simCheck] } return

  set w .prntdlg

  if { [catch {toplevel $w}] } {
    return
  }

  wm transient $w .scope

  set pd_title $tkg_displayFile
  set pd_file  [replaceExtension $tkg_currentFile "_trace.ps"]
  set p [string last "/" $pd_file]
  if { $p >= 0 } { set pd_file [string range $pd_file [expr $p + 1] end]}

  set pd_ok 0

  wm resizable $w 0 0
  wm title $w "TKGate: Scope Print"
  wm geometry $w [offsetgeometry . 50 50 ]

  frame $w.left
  frame $w.right

  tkg_prntOutSel $w.left.out $w.left.lpr $w.left.file
  tkg_prntLprSel $w.left.lpr raised
  tkg_prntFileSel $w.left.file
  tkg_prntPaperSel $w.left.paper raised
  tkg_prntTitleSel $w.left.title
  tkg_prntRangeSel $w.right.range
  tkg_prntRangeScale $w.right.scale
  okcancel $w.okc "global pd_ok; set pd_ok 1; destroy .prntdlg" { destroy .prntdlg }

  bind $w <Return> "global pd_ok; set pd_ok 1; destroy .prntdlg"

  pack $w.okc -fill both -side bottom
  pack $w.left $w.right -side left -fill both

  pack $w.left.out -ipadx 5 -ipady 5 -fill both
  pack $w.left.lpr -ipadx 5 -ipady 5 -fill both
  pack $w.left.file -ipadx 5 -ipady 5 -fill both
  pack $w.left.paper -ipadx 5 -ipady 5 -fill both -expand 1
  pack $w.left.title -ipadx 5 -ipady 5 -fill both

  tkg_outSelect $w.left.lpr $w.left.file

  grab set $w
  tkwait window $w
  grab release $w

  if {$pd_ok} {
    global pd_file pd_paper pd_paperSizes pd_orient pd_epsf pd_title pd_duplexMode page_estimate

    if { $page_estimate > 40 } {
      if {[tk_messageBox -type yesno -default no -message [m err.manypages]] != "yes"} {
	return
      }
    }

    scan $pd_paperSizes($pd_paper) "%s" curSize

    if {$pd_isfile} {
      gat_tracePrint -file $pd_file -paper $curSize -orient $pd_orient -epsf $pd_epsf -title $pd_title -duplex $pd_duplexMode -scale $prs_scale -start $prs_start -end $prs_end
    } { 
      gat_tracePrint -printer $pd_print -paper $curSize -orient $pd_orient -epsf $pd_epsf -title $pd_title -duplex $pd_duplexMode -scale $prs_scale -start $prs_start -end $prs_end
    }
  }
}

