'\"
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\" Copyright (c) 2004 Joe English
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH ttk::scrollbar n 8.5 Tk "Tk Themed Widget"
.BS
.SH NAME
ttk::scrollbar \- Control the viewport of a scrollable widget 
.SH SYNOPSIS
\fBttk::scrollbar\fR \fIpathName \fR?\fIoptions...\fR?
.BE
.SH DESCRIPTION
.PP
\fBttk::scrollbar\fR widgets are typically linked to an associated window
that displays a document of some sort, such as a file being edited or a
drawing.
A scrollbar displays a \fIthumb\fR in the middle portion of the scrollbar,
whose position and size provides information about the portion of the
document visible in the associated window.
The thumb may be dragged by the user to control the visible region.
Depending on the theme, two or more arrow buttons may also be present;
these are used to scroll the visible region in discrete units.
.SO ttk_widget
\-class	\-cursor	\-style
\-takefocus
.SE
.SH "WIDGET-SPECIFIC OPTIONS"
.OP \-command command Command
A Tcl script prefix to evaluate 
to change the view in the widget associated with the scrollbar.
Additional arguments are appended to the value of this option,
as described in \fBSCROLLING COMMANDS\fR below,
whenever the user requests a view change by manipulating the scrollbar.
.RS
.PP
This option typically consists of a two-element list,
containing the name of a scrollable widget followed by
either \fBxview\fR (for horizontal scrollbars)
or \fByview\fR (for vertical scrollbars).
.RE
.OP \-orient orient Orient
One of \fBhorizontal\fR or \fBvertical\fR.
Specifies the orientation of the scrollbar.
.SH "WIDGET COMMAND"
.PP
.TP
\fIpathName \fBcget \fIoption\fR
Returns the current value of the specified \fIoption\fR; see \fIttk::widget(n)\fR.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Modify or query widget options; see \fIttk::widget(n)\fR.
.TP
\fIpathName \fBget\fR
Returns the scrollbar settings in the form of a list whose
elements are the arguments to the most recent \fBset\fR widget command.
.TP
\fIpathName \fBidentify \fIx y\fR
Returns the name of the element at position \fIx\fR, \fIy\fR.
See \fIttk::widget(n)\fR.
.TP
\fIpathName \fBinstate \fIstatespec\fR ?\fIscript\fR?
Test the widget state; see \fIttk::widget(n)\fR.
.TP
\fIpathName \fBset \fIfirst last\fR
This command is normally invoked by the scrollbar's associated widget 
from an \fB\-xscrollcommand\fR or \fB\-yscrollcommand\fR callback.
Specifies the visible range to be displayed.
\fIfirst\fR and \fIlast\fR are real fractions between 0 and 1.
.TP
\fIpathName \fBstate\fR ?\fIstateSpec\fR?
Modify or query the widget state; see \fIttk::widget(n)\fR.
.SH "INTERNAL COMMANDS"
.PP
The following widget commands are used internally
by the TScrollbar widget class bindings.
.TP
\fIpathName \fBdelta \fIdeltaX deltaY\fR
Returns a real number indicating the fractional change in
the scrollbar setting that corresponds to a given change
in thumb position.  For example, if the scrollbar is horizontal,
the result indicates how much the scrollbar setting must change
to move the thumb \fIdeltaX\fR pixels to the right (\fIdeltaY\fR is
ignored in this case).
If the scrollbar is vertical, the result indicates how much the
scrollbar setting must change to move the thumb \fIdeltaY\fR pixels
down.  The arguments and the result may be zero or negative.
.TP
\fIpathName \fBfraction \fIx y\fR
Returns a real number between 0 and 1 indicating where the point
given by \fIx\fR and \fIy\fR lies in the trough area of the scrollbar,
where 0.0 corresponds to the top or left of the trough
and 1.0 corresponds to the bottom or right.
\fIX\fR and \fIy\fR are pixel coordinates relative to the scrollbar
widget.
If \fIx\fR and \fIy\fR refer to a point outside the trough, the closest
point in the trough is used.
.SH "SCROLLING COMMANDS"
.PP
When the user interacts with the scrollbar, for example by dragging
the thumb, the scrollbar notifies the associated widget that it
must change its view.
The scrollbar makes the notification by evaluating a Tcl command
generated from the scrollbar's \fB\-command\fR option.
The command may take any of the following forms.
In each case, \fIprefix\fR is the contents of the
\fB\-command\fR option, which usually has a form like \fB.t yview\fR
.TP
\fIprefix \fBmoveto \fIfraction\fR
\fIFraction\fR is a real number between 0 and 1.
The widget should adjust its view so that the point given
by \fIfraction\fR appears at the beginning of the widget.
If \fIfraction\fR is 0 it refers to the beginning of the
document.  1.0 refers to the end of the document, 0.333
refers to a point one-third of the way through the document,
and so on.
.TP
\fIprefix \fBscroll \fInumber \fBunits\fR
The widget should adjust its view by \fInumber\fR units.
The units are defined in whatever way makes sense for the widget,
such as characters or lines in a text widget.
\fINumber\fR is either 1, which means one unit should scroll off
the top or left of the window, or \-1, which means that one unit
should scroll off the bottom or right of the window.
.TP
\fIprefix \fBscroll \fInumber \fBpages\fR
The widget should adjust its view by \fInumber\fR pages.
It is up to the widget to define the meaning of a page;  typically
it is slightly less than what fits in the window, so that there
is a slight overlap between the old and new views.
\fINumber\fR is either 1, which means the next page should
become visible, or \-1, which means that the previous page should
become visible.
.SH "WIDGET STATES"
.PP
The scrollbar automatically sets the \fBdisabled\fR state bit.
when the entire range is visible (range is 0.0 to 1.0),
and clears it otherwise.
It also sets the \fBactive\fR and \fBpressed\fR state flags
of individual elements, based on the position and state of the mouse pointer.
.SH EXAMPLE
.PP
.CS
set f [frame .f]
ttk::scrollbar $f.hsb \-orient horizontal \-command [list $f.t xview]
ttk::scrollbar $f.vsb \-orient vertical \-command [list $f.t yview]
text $f.t \-xscrollcommand [list $f.hsb set] \-yscrollcommand [list $f.vsb set] 
grid $f.t \-row 0 \-column 0 \-sticky nsew
grid $f.vsb \-row 0 \-column 1 \-sticky nsew
grid $f.hsb \-row 1 \-column 0 \-sticky nsew
grid columnconfigure $f 0 \-weight 1
grid rowconfigure $f 0 \-weight 1
.CE
.SH "SEE ALSO"
ttk::widget(n), scrollbar(n)
.SH KEYWORDS
scrollbar, widget
'\" Local Variables:
'\" mode: nroff
'\" End:
