/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPTIONEN_H
#define OPTIONEN_H

#include "UrlSelectPanel.H"
#include <wx/wx.h>
#include <wx/checkbox.h>

class ODialog: public wxDialog {
public:
  ODialog(wxWindow* parent);
  ~ODialog();
  
private:
  wxCheckBox* langOverride;
  wxComboBox* langSel;
  wxCheckBox* keybOverride;
  wxComboBox* keybSel;
  wxCheckBox* dataOverride;
  UrlSelectPanel* url;

  wxPanel* getDataLocationPage (wxWindow* parent);
  wxSizer* getSourceSizer (wxWindow* parent);
  wxPanel* getLocalizationPage (wxWindow* parent);
  wxComboBox* getLangSelector (wxWindow* parent);
  wxComboBox* getKeyboardSelector (wxWindow* parent);

  void OnSave(wxCommandEvent& event);
  void OnCheckBox (wxCommandEvent& event);

  DECLARE_EVENT_TABLE()
};

#endif
