##############################################################################
#
# Copyright (c) 2005-2006 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import pooler
import time
from report import report_sxw

class grand_livre_tiers(report_sxw.rml_parse):
	def __init__(self, cr, uid, name, context):
		super(grand_livre_tiers, self).__init__(cr, uid, name, context)
		self.localcontext.update( {
			'time': time,
			'lines': self.lines,
			'sum_debit_partner': self._sum_debit_partner,
			'sum_credit_partner': self._sum_credit_partner,
			'sum_debit': self._sum_debit,
			'sum_credit': self._sum_credit
		})

	def preprocess(self, objects, data, ids):
		self.cr.execute(
			"SELECT DISTINCT partner_id " \
			"FROM account_move_line " \
			"WHERE partner_id IS NOT NULL AND date>=%s AND date<=%s AND state<>'draft'", 
			(data['form']['date1'], data['form']['date2']))
		new_ids = [id for (id,) in self.cr.fetchall()]
		self.cr.execute(
			"SELECT a.id " \
			"FROM account_account a LEFT JOIN account_account_type t ON (a.type=t.code) " \
			"WHERE t.partner_account=TRUE")
		self.account_ids = ','.join([str(a) for (a,) in self.cr.fetchall()])
		self.partner_ids = ','.join(map(str, new_ids))
		objects = self.pool.get('res.partner').browse(self.cr, self.uid, new_ids)
		super(grand_livre_tiers, self).preprocess(objects, data, new_ids)

	def lines(self, partner):
		self.cr.execute(
			"SELECT l.date, j.code, l.ref, l.name, l.debit, l.credit " \
			"FROM account_move_line l LEFT JOIN account_journal j ON (l.journal_id=j.id) " \
			"WHERE l.partner_id=%d " \
			"AND l.account_id IN (" + self.account_ids + ") " \
			"AND l.date>=%s AND l.date<=%s  AND state<>'draft'" \
			"ORDER BY l.id", 
			(partner.id, self.datas['form']['date1'], self.datas['form']['date2']))
		res = self.cr.dictfetchall()
		sum = 0.0
		for r in res:
			sum += r['debit'] - r['credit']
			r['progress'] = sum 
		return res
		
	def _sum_debit_partner(self, partner):
		self.cr.execute(
			"SELECT sum(debit) " \
			"FROM account_move_line " \
			"WHERE partner_id=%d " \
			"AND account_id IN (" + self.account_ids + ") " \
			"AND date>=%s AND date<=%s AND state<>'draft'",
			(partner.id, self.datas['form']['date1'], self.datas['form']['date2']))
		return self.cr.fetchone()[0] or 0.0
		
	def _sum_credit_partner(self, partner):
		self.cr.execute(
			"SELECT sum(credit) " \
			"FROM account_move_line " \
			"WHERE partner_id=%d " \
			"AND account_id IN (" + self.account_ids + ") " \
			"AND date>=%s AND date<=%s AND state<>'draft'",
			(partner.id, self.datas["form"]["date1"], self.datas["form"]["date2"]))
		return self.cr.fetchone()[0] or 0.0
		
	def _sum_debit(self):
		if not self.ids:
			return 0.0

		self.cr.execute(
			"SELECT sum(debit) " \
			"FROM account_move_line " \
			"WHERE partner_id IN (" + self.partner_ids + ") " \
			"AND account_id IN (" + self.account_ids + ") " \
			"AND date>=%s AND date<=%s AND state<>'draft'", 
			(self.datas['form']['date1'], self.datas['form']['date2']))
		return self.cr.fetchone()[0] or 0.0
		
	def _sum_credit(self):
		if not self.ids:
			return 0.0

		self.cr.execute(
			"SELECT sum(credit) " \
			"FROM account_move_line " \
			"WHERE partner_id IN (" + self.partner_ids + ") " \
			"AND account_id IN (" + self.account_ids + ") " \
			"AND date>=%s AND date<=%s AND state<>'draft'", 
			(self.datas['form']['date1'], self.datas['form']['date2']))
		return self.cr.fetchone()[0] or 0.0
report_sxw.report_sxw('report.account.grand.livre.tiers', 'res.partner', 'addons/account/report/grand_livre_tiers.rml',parser=grand_livre_tiers)

