<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<xsl:template match="/">
		<document>
			<template pageSize="21cm,29.7cm" leftMargin="1.5cm" rightMargin="1.5cm" topMargin="1.5cm" bottomMargin="1.5cm" title="Bordereau acheteur" author="Generated by Tiny ERP, Fabien Pinckaers" allowSplitting="20">
				<pageTemplate id="all">
					<pageGraphics/>
					<frame id="list" x1="1.0cm" y1="2.0cm" width="19.0cm" height="27cm"/>
				</pageTemplate>				
			</template>

			<stylesheet>
				<paraStyle name="cost-name" fontName="Helvetica-Bold" fontSize="12" textColor="white" alignment="center"/>
				<blockTableStyle id="list">
					 <blockValign value="TOP"/>
					 <blockAlignment value="CENTER" start="0,0" stop="-1,0"/>
					 <blockAlignment value="RIGHT" start="0,1" stop="0,-1"/>
					 <blockAlignment value="RIGHT" start="2,1" stop="-1,-1"/>
					 <blockFont name="Helvetica-BoldOblique" size="12" start="0,0" stop="-1,0"/>
					 <blockBackground colorName="grey" start="0,0" stop="-1,0"/>
					 <blockTextColor colorName="white" start="0,0" stop="-1,0"/>
					 <lineStyle kind="LINEBELOW" colorName="grey" start="0,1" stop="-1,-1"/>
					 <lineStyle kind="LINEBEFORE" colorName="black" start="0,1" stop="0,-1"/>
					 <lineStyle kind="LINEBEFORE" colorName="grey" start="1,1" stop="-1,-1"/>
					 <lineStyle kind="LINEAFTER" colorName="black" start="-1,1" stop="-1,-1"/>
				</blockTableStyle>
			</stylesheet>
			
			<story>
				<xsl:apply-templates select="invoice-list"/>
			</story>
		</document>
	</xsl:template>

	<xsl:template match="invoice-list">
		<xsl:variable name="colWidths">
			<xsl:text>1.5cm,6.5cm,2.0cm</xsl:text>
			<xsl:for-each select="//cost-index">
<!--			<xsl:for-each select="invoice/invoice-lines/tax-line[not(id = preceding-sibling::id)]">
-->
				<xsl:text>,2cm</xsl:text>
			</xsl:for-each>
			<xsl:text>,2.0cm</xsl:text>
		</xsl:variable>

		<blockTable style="list" repeatRows="1"> 
			<xsl:attribute name="colWidths">
				<xsl:value-of select="$colWidths"/>
			</xsl:attribute>
			<tr>
				<td t="1">Id</td>
				<td t="1">Customer</td>
				<td t="1">Amount</td>
<!--				<xsl:for-each select="invoice/invoice-lines/tax-line[not(id = preceding-sibling::id)]">-->
				<xsl:for-each select="//cost-index">
					<td><para style="cost-name"><xsl:value-of select="name"/></para></td>
				</xsl:for-each>
				<td t="1">Total</td>
			</tr>
			<xsl:apply-templates select="invoice">
				<xsl:sort select="number" data-type="number"/>
			</xsl:apply-templates>
		</blockTable>
	</xsl:template>

	<xsl:template match="invoice">
		<xsl:variable name="inv_id" select="id"/>

		<tr>
			<td><xsl:value-of select="number"/></td>
			<td><para><xsl:value-of select="client-name"/></para></td>
			<td><xsl:value-of select="format-number(sum(invoice-lines/invoice-line/amount), '#,##0.00')"/></td>
			<xsl:for-each select="//cost-index">
				<xsl:variable name="tax_name" select="name"/>
				<td>
					<xsl:if test="//invoice[id=$inv_id]/invoice-lines/tax-line[name=$tax_name]/amount != ''">
						<xsl:value-of select="format-number(//invoice[id=$inv_id]/invoice-lines/tax-line[name=$tax_name]/amount, '#,##0.00')"/>
					</xsl:if>
				</td>
			</xsl:for-each>
			<td><xsl:value-of select="format-number(sum(invoice-lines/invoice-line/amount) + sum(invoice-lines/tax-line/amount), '#,##0.00')"/></td>
		</tr>
	</xsl:template>

</xsl:stylesheet>
