##############################################################################
#
# Copyright (c) 2004-2006 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import sql_db
import time
from report import report_sxw

class account_balance(report_sxw.rml_parse):
	def __init__(self, name, table, rml):
		super(account_balance, self).__init__(name, table, rml)
		self.localcontext.update({
			'time': time,
			'lines': self.lines,
			'sum_debit': self._sum_debit,
			'sum_credit': self._sum_credit,
			'sum_sdebit': self._sum_sdebit,
			'sum_scredit': self._sum_scredit
		})

	def preprocess(self, objects, data, ids):
		# compute the list of accounts to work on, that is: the accounts the user
		# selected AND all their childs
		def _rec_account_get(cr, uid, accounts, found=None):
			if not found:
				found = []
			for acc in accounts:
				if acc.id not in found:
					found.append(acc.id)
					_rec_account_get(cr, uid, acc.child_id, found)
			return found
		toprocess = self.pool.get('account.account').browse(self.cr, self.uid, ids)
		newids = _rec_account_get(self.cr, self.uid, toprocess)
		# filter out accounts which have no transaction in them
		self.cr.execute(
			'SELECT DISTINCT account_id ' \
			'FROM account_move_line ' \
			'WHERE date>=%s AND date<=%s ' \
			'AND account_id IN (' + ','.join(map(str,newids)) + ')',
			(data['form']['date1'], data['form']['date2']))
		newids = [id for (id,) in self.cr.fetchall()]
		objects = self.pool.get('account.account').browse(self.cr, self.uid, newids)
		super(account_balance, self).preprocess(objects, data, newids)
		
	def lines(self):
		if not self.ids:
			return []

		self.cr.execute(
			'select a.code, a.name, sum(debit) as debit, sum(credit) as credit ' \
			'from account_move_line l left join account_account a on (l.account_id=a.id) ' \
			'where account_id in (' + ','.join(map(str, self.ids)) + ') ' \
			'and date>=%s and date<=%s ' \
			'group by a.id, a.code, a.name order by a.code',
			(self.datas['form']['date1'], self.datas['form']['date2']))
		res = self.cr.dictfetchall()
		for r in res:
			r['sdebit'] = r['debit'] > r['credit'] and r['debit'] - r['credit']
			r['scredit'] = r['credit'] > r['debit'] and r['credit'] - r['debit']
		return res
		
	def _sum_debit(self):
		if not self.ids:
			return 0.0

		self.cr.execute('select sum(debit) from account_move_line where account_id in (' + ','.join(map(str, self.ids)) + ') and date>=%s and date<=%s', (self.datas['form']['date1'], self.datas['form']['date2']))
		return self.cr.fetchone()[0] or 0.0
		
	def _sum_credit(self):
		if not self.ids:
			return 0.0

		self.cr.execute('select sum(credit) from account_move_line where account_id in (' + ','.join(map(str, self.ids)) + ') and date>=%s and date<=%s', (self.datas['form']['date1'], self.datas['form']['date2']))
		return self.cr.fetchone()[0] or 0.0
	
	def _sum_sdebit(self):
		debit, credit = self._sum_debit(), self._sum_credit()
		return debit > credit and debit - credit
		
	def _sum_scredit(self):
		debit, credit = self._sum_debit(), self._sum_credit()
		return credit > debit and credit - debit
	
report_sxw.report_sxw('report.account.account.balance', 'account.account', 'addons/account/report/account_balance.rml', parser=account_balance)

