##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# $Id: config.py 996 2005-07-22 10:40:10Z nicoe $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import ConfigParser,optparse,os,sys


class configmanager(object):
	def __init__(self, fname=None):
		self.options = {
			'verbose': False,
			'interface': '',	# this will bind the server to all interfaces
			'port': '8069',
			'db_host': False,
			'db_port': False,
			'db_name': 'terp',
			'db_user': False,
			'db_password': False,
			'webdb_host': False,
			'webdb_port': False,
			'webdb_name': False,
			'webdb_user': False,
			'webdb_password': False,
			'reportgz': False,
			'netrpc': True,
			'xmlrpc': True,
			'soap': False,
			'translate_in': None,
			'translate_out': None,
			'language': None,
			'addons_path' : None,
			'root_path' : None,
		}

		parser = optparse.OptionParser(version=tinyerp_version_string)
		
		parser.add_option("-c", "--config", dest="config", help="specify alternate config file")
		parser.add_option("-s", "--save", action="store_true", dest="save", default=False, help="save configuration to ~/.terp_serverrc")
		parser.add_option("-v", "--verbose", action="store_true", dest="verbose", default=False, help="enable debugging")
		
		parser.add_option("-n", "--interface", dest="interface", help="specify the TCP IP address")
		parser.add_option("-p", "--port", dest="port", help="specify the TCP port")
		
		parser.add_option("-i", "--init", dest="init", help="init a module (use \"all\" for all modules)")
		parser.add_option("--without-demo", dest="without_demo", help="load demo data for a module (use \"all\" for all modules)", default=False)
		parser.add_option("-u", "--update", dest="update", help="update a module (use \"all\" for all modules)")
		
		group = optparse.OptionGroup(parser, "Modules related options")
		group.add_option("-g", "--upgrade", action="store_true", dest="upgrade", default=False, help="Upgrade/install/uninstall modules")

		group = optparse.OptionGroup(parser, "Database related options")
		group.add_option("-d", "--database", dest="db_name", help="specify the database name")
		group.add_option("-r", "--db_user", dest="db_user", help="specify the database user name")
		group.add_option("-w", "--db_password", dest="db_password", help="specify the database password") 
		group.add_option("--db_host", dest="db_host", help="specify the database host") 
		group.add_option("--db_port", dest="db_port", help="specify the database port") 
		parser.add_option_group(group)
		
		group = optparse.OptionGroup(parser, "Customer Satisfaction Database related options")
		group.add_option("--webdatabase", dest="webdb_name", help="specify the customer satisfaction database name")
		group.add_option("--webdb_user", dest="webdb_user", help="specify the customer satisfaction database user name")
		group.add_option("--webdb_password", dest="webdb_password", help="specify the customer satisfaction database password") 
		group.add_option("--webdb_host", dest="webdb_host", help="specify the customer satisfaction database host") 
		group.add_option("--webdb_port", dest="webdb_port", help="specify the customer satisfaction database port") 
		parser.add_option_group(group)

		group = optparse.OptionGroup(parser, "Internationalisation options",
			  "Use these options to translate Tiny ERP to another language. "
			  "See i18n section of the user manual. Option '-l' is mandatory.")

		group.add_option('-l', "--language", dest="language", help="specify the language of the translation file. Use it with --i18n-export and --i18n-import")
		group.add_option("--i18n-export", dest="translate_out", help="export all sentences to be translated to a CSV file and exit")
		group.add_option("--i18n-import", dest="translate_in", help="import a CSV file with translations and exit")
		group.add_option("--modules", dest="translate_modules", help="specify modules to export. Use in combination with --i18n-export")
		parser.add_option_group(group)

		(opt, args) = parser.parse_args()

		if (opt.translate_in or opt.translate_out) and not opt.language:
			print "Error: the i18n-import and i18n-export options cannot be used without the language option"
			sys.exit(2)

		self.rcfile = fname or opt.config or os.environ.get('TERP_SERVER') or os.path.expanduser('~/.terp_serverrc')
		self.load()
		
		for arg in ('interface', 'port', 'db_name', 'db_user', 'db_password', 'db_host', 'db_port', 'webdb_name', 'webdb_user', 'webdb_password', 'webdb_host', 'webdb_port'):
			if getattr(opt, arg):
				self.options[arg] = getattr(opt, arg)

		for arg in ('language', 'translate_out', 'translate_in'):
			self.options[arg] = getattr(opt, arg)
			
		self.options['upgrade'] = opt.upgrade
		self.options['verbose'] = opt.verbose

		init = {}
		if opt.init:
			for i in opt.init.split(','):
				init[i] = 1
		self.options['init'] = init
		self.options['without_demo'] = opt.without_demo
		self.options["demo"] = not opt.without_demo and self.options['init'] or {}

		update = {}
		if opt.update:
			for i in opt.update.split(','):
				update[i] = 1
		self.options['update'] = update
		
		self.options['translate_modules'] = opt.translate_modules and opt.translate_modules.split(',') or ['all']

		if self.options.get('language', False):
			assert len(self.options['language'])==2, 'ERROR: The Lang name must take 2 chars, Eg: -lfr !!!'
		if opt.save:
			self.save()

	def load(self):
		p = ConfigParser.ConfigParser()
		try:
			p.read([self.rcfile])
			for (name,value) in p.items('options'):
				if value=='True' or value=='true':
					value = True
				if value=='False' or value=='false':
					value = False
				self.options[name] = value
		except IOError:
			pass
		except ConfigParser.NoSectionError:
			pass

	def save(self):
		p = ConfigParser.ConfigParser()
		p.add_section('options')
		for o in [opt for opt in self.options.keys() if opt not in ('version','language','translate_out','translate_in','init','update')]:
			p.set('options',o, self.options[o])
		p.write(file(self.rcfile,'wb'))

	def get(self, key, default=None):
		return self.options.get(key, default)

	def __setitem__(self, key, value):
		self.options[key] = value

	def __getitem__(self, key):
		return self.options[key]

config=configmanager()


