##############################################################################
#
# Copyright (c) 2005 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# $Id$
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import wizard
import netsvc

copy_form = """<?xml version="1.0" ?>
<form string="Project copy">
	<separator string="By using this wizard you will deactivate the following project(s) and their childs" colspan="4" />
	<field name="proj_name" />
</form>"""

copy_fields = {
	'proj_name' : {'string' : 'Projects name', 'type': 'char', 'readonly' : 'True', 'size' : 256 },
}

ack_form = """<?xml version="1.0" ?>
<form string="Project copy">
	<separator string="Deactivation successfull" />
</form>"""

ack_fields = {}

def _get_name(wizard, uid, datas):
	service = netsvc.LocalService('object_proxy')
	service.execute(uid, 'project.project', 'read', datas['ids'], ['name'])
	return {'proj_name': ','.join([p['name'] for p in projects])}

def _do_inactivate(wizard, uid, datas):
	service = netsvc.LocalService('object_proxy')
	service.execute(uid, 'project.project', 'deactivate', datas['ids'])
	return {}

class wiz_deactivate(wizard.interface):
	states = {
		'init' : {
			'actions' : [_get_name],
			'result' : {'type': 'form', 'arch' : copy_form, 'fields' : copy_fields, 'state' : [('inactivate', 'Inactivate'), ('end', 'Cancel')] },
		},
		'inactivate' : {
			'actions' : [_do_inactivate],
			'result' : {'type' : 'form', 'arch' : ack_form, 'fields' : ack_fields, 'state' : [('end', 'Ok')] },
		},
	}
wiz_deactivate('project.wiz_deactivate')
