##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import sql_db
import time
from report import report_sxw

class grand_livre_tiers(report_sxw.report_sxw):
	def __init__(self, name, table, rml):
		super(grand_livre_tiers, self).__init__(name, table, rml)
		self.localcontext = {
			'time': time,
			'lines': self.lines,
			'sum_debit_partner': self._sum_debit_partner,
			'sum_credit_partner': self._sum_credit_partner,
			'sum_debit': self._sum_debit,
			'sum_credit': self._sum_credit
		}
		
	def create(self, uid, ids, data, context):
		cr = sql_db.db.cursor()
		cr.execute('select distinct partner_id from account_move_line where partner_id is not null and date>=%s and date<=%s', (data['form']['date1'], data['form']['date2']))
		new_ids = map(lambda x: x[0], cr.fetchall())
		cr.close()
		super(grand_livre_tiers, self).create(uid, new_ids, data, context)
		
	def lines(self, partner):
		self.cr.execute('select l.date, j.code, l.ref, l.name, l.debit, l.credit from account_move_line l left join account_journal j on (l.journal_id=j.id) where partner_id=%d and date>=%s and date<=%s order by l.id', (partner.id, self.datas['form']['date1'], self.datas['form']['date2']))
		res = self.cr.dictfetchall()
		sum = 0.0
		for r in res:
			sum += r['debit'] - r['credit']
			r['progress'] = sum 
		return res
		
	def _sum_debit_partner(self, partner):
		self.cr.execute('select sum(debit) from account_move_line where partner_id=%d and date>=%s and date<=%s', (partner.id, self.datas['form']['date1'], self.datas['form']['date2']))
		return self.cr.fetchone()[0] or 0.0
		
	def _sum_credit_partner(self, partner):
		self.cr.execute('select sum(credit) from account_move_line where partner_id=%d and date>=%s and date<=%s', (partner.id, self.datas['form']['date1'], self.datas['form']['date2']))
		return self.cr.fetchone()[0] or 0.0
		
	def _sum_debit(self):
		if not self.ids:
			return 0.0

		self.cr.execute('select sum(debit) from account_move_line where partner_id in (' + ','.join(map(str, self.ids)) + ') and date>=%s and date<=%s', (self.datas['form']['date1'], self.datas['form']['date2']))
		return self.cr.fetchone()[0] or 0.0
		
	def _sum_credit(self):
		if not self.ids:
			return 0.0

		self.cr.execute('select sum(credit) from account_move_line where partner_id in (' +','.join(map(str, self.ids)) + ') and date>=%s and date<=%s', (self.datas['form']['date1'], self.datas['form']['date2']))
		return self.cr.fetchone()[0] or 0.0
grand_livre_tiers('report.account.grand.livre.tiers', 'res.partner', 'addons/account/report/grand_livre_tiers.rml')

